/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.components;

import de.duehl.vocabulary.japanese.common.data.TranslationDirection;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.ui.VocabularyTrainerGui;
import de.duehl.vocabulary.japanese.ui.tools.VocabularyTrainerUiTools;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JPanel;

public class TranslationDirectionGuiWithSwitchButton {
    private static final String GERMAN_JAPANESE_ACTIVE_NAME = "GERMAN_JAPANESE_ACTIVE_NAME";
    private static final String JAPANESE_GERMAN_ACTIVE_NAME = "JAPANISCH_DEUTSCH_AKTIV_NAME";
    private final Options options;
    private final VocabularyTrainerGui gui;
    private final JPanel panel;
    private final JPanel switchingContentButtonPanel;
    private final CardLayout cardLayout;
    private final JButton japaneseToGermanTranslationButton;
    private final JButton germanToJapaneseTranslationButton;

    public TranslationDirectionGuiWithSwitchButton(Options options, VocabularyTrainerGui vocabularyTrainerGui) {
        this.options = options;
        this.gui = vocabularyTrainerGui;
        this.panel = new JPanel();
        this.japaneseToGermanTranslationButton = this.createUmschalterJapanischDeutschIsActiveButton();
        this.germanToJapaneseTranslationButton = this.createUmschalterDeutschJapanischIsActiveButton();
        this.switchingContentButtonPanel = new JPanel();
        this.cardLayout = new CardLayout();
        this.init();
        this.switchToCorrectButtonDependingOnOptions();
    }

    private JButton createUmschalterJapanischDeutschIsActiveButton() {
        JButton jButton = VocabularyTrainerUiTools.createPicturedButton("UMSCHALTER_JAPANISCH_DEUTSCH", actionEvent -> this.switchToDeutschJapanisch(), "Zur \u00dcbersetzungsrichtung Deutsch-Japanisch umschalten");
        return jButton;
    }

    private JButton createUmschalterDeutschJapanischIsActiveButton() {
        JButton jButton = VocabularyTrainerUiTools.createPicturedButton("UMSCHALTER_DEUTSCH_JAPANISCH", actionEvent -> this.switchToJapanischDeutsch(), "Zur \u00dcbersetzungsrichtung Japanisch-Deutsch umschalten");
        return jButton;
    }

    private void switchToDeutschJapanisch() {
        TranslationDirection translationDirection = TranslationDirection.GERMAN_TO_JAPANESE;
        String string = GERMAN_JAPANESE_ACTIVE_NAME;
        this.switchCardAndActivateTranslationDirection(translationDirection, string);
    }

    private void switchToJapanischDeutsch() {
        TranslationDirection translationDirection = TranslationDirection.JAPANESE_TO_GERMAN;
        String string = JAPANESE_GERMAN_ACTIVE_NAME;
        this.switchCardAndActivateTranslationDirection(translationDirection, string);
    }

    private void switchCardAndActivateTranslationDirection(TranslationDirection translationDirection, String string) {
        this.showButton(string);
        this.options.setTranslationDirection(translationDirection);
        this.gui.showTranslationDirectionOnBarButtons();
        this.gui.setCorrectForegroundColorOfVocabularyBarsLater();
    }

    private void showButton(String string) {
        this.cardLayout.show(this.switchingContentButtonPanel, string);
        this.panel.repaint();
    }

    private void init() {
        this.initSwitchingButtonCardPane();
        this.initPanel();
    }

    private void initSwitchingButtonCardPane() {
        this.switchingContentButtonPanel.setLayout(this.cardLayout);
        this.switchingContentButtonPanel.add((Component)this.japaneseToGermanTranslationButton, JAPANESE_GERMAN_ACTIVE_NAME);
        this.switchingContentButtonPanel.add((Component)this.germanToJapaneseTranslationButton, GERMAN_JAPANESE_ACTIVE_NAME);
    }

    private void initPanel() {
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this.switchingContentButtonPanel, "Center");
    }

    private void switchToCorrectButtonDependingOnOptions() {
        TranslationDirection translationDirection = this.options.getTranslationDirection();
        if (translationDirection == TranslationDirection.JAPANESE_TO_GERMAN) {
            this.showButton(JAPANESE_GERMAN_ACTIVE_NAME);
        } else if (translationDirection == TranslationDirection.GERMAN_TO_JAPANESE) {
            this.showButton(GERMAN_JAPANESE_ACTIVE_NAME);
        } else {
            throw new RuntimeException("Unbekannte TranslationDirection " + translationDirection + ".");
        }
    }

    public JPanel getPanel() {
        return this.panel;
    }
}

