/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.components.text;

import de.duehl.basics.text.Text;
import de.duehl.basics.text.html.HtmlTool;
import de.duehl.vocabulary.japanese.data.Vocable;
import java.util.ArrayList;
import java.util.List;

public class VocaleBarTextCreator {
    private static final String CENTERED_HTML_START = "<html><center>";
    private static final String CENTERED_HTML_END = "<center></html>";
    private static final String BIG_BOLD_START = "<span style=\"font-weight:bold; font-size:24\">";
    private static final String NORMAL_BOLD_START = "<span style=\"font-weight:bold; font-size:20\">";
    private static final String BOLD_END = "</span>";
    private static final int CHARACTERS_PER_LINE = 35;
    private static final String OPENING_BRACE_TEXT = " (";
    private static final String CLOSING_BRACE_TEXT = ") - ";
    private static final boolean INSERT_TYPE_INTO_TEXT = false;
    private final String kanji;
    private final String kana;
    private final String romaji;
    private final String firstTranslation;
    private String text;
    private boolean showKanji;

    public VocaleBarTextCreator(Vocable vocable) {
        this.kanji = vocable.getKanji();
        this.kana = vocable.getKana();
        this.romaji = vocable.getRomaji();
        this.firstTranslation = vocable.getTranslations().get(0);
        this.showKanji = !this.kanji.isBlank() && !this.kanji.equals(this.kana);
    }

    public void create() {
        String string = this.createTextBeforeBrace();
        String string2 = this.createFirstTextInBrace();
        String string3 = this.romaji;
        String string4 = this.firstTranslation;
        String string5 = OPENING_BRACE_TEXT + string2 + string3 + CLOSING_BRACE_TEXT;
        String string6 = string + string5 + string4;
        this.text = string6.length() <= 35 ? (this.showKanji ? this.createSingleLineTextWithKanji() : this.createSingleLineTextWithoutKanji()) : (string.length() <= 35 && string5.length() <= 35 && string4.length() <= 35 ? (this.showKanji ? this.createThreeLinesTextWithKanji() : this.createThreeLinesTextWithoutKanji()) : (this.showKanji && string.length() <= 35 && string2.length() <= 35 && string3.length() <= 35 && string4.length() <= 35 ? this.createFourLinesTextWithKanji() : (this.showKanji ? this.createLongerTextWithKanji() : this.createLongerTextWithoutKanji())));
    }

    private String createTextBeforeBrace() {
        if (this.showKanji) {
            return this.kanji;
        }
        return this.kana;
    }

    private String createFirstTextInBrace() {
        if (this.showKanji) {
            return this.kana + ", ";
        }
        return "";
    }

    private String createSingleLineTextWithKanji() {
        String string = BIG_BOLD_START + HtmlTool.encodeHtmlOnlyLtGt(this.kanji) + BOLD_END;
        String string2 = NORMAL_BOLD_START + HtmlTool.encodeHtmlOnlyLtGt(this.kana) + BOLD_END;
        String string3 = HtmlTool.encodeHtmlOnlyLtGt(this.romaji);
        String string4 = HtmlTool.encodeHtmlOnlyLtGt(this.firstTranslation);
        Object object = CENTERED_HTML_START;
        object = (String)object + string + OPENING_BRACE_TEXT + string2 + ", ";
        object = (String)object + string3 + CLOSING_BRACE_TEXT + string4;
        object = (String)object + CENTERED_HTML_END;
        return object;
    }

    private String createSingleLineTextWithoutKanji() {
        String string = BIG_BOLD_START + HtmlTool.encodeHtmlOnlyLtGt(this.kana) + BOLD_END;
        String string2 = HtmlTool.encodeHtmlOnlyLtGt(this.romaji);
        String string3 = HtmlTool.encodeHtmlOnlyLtGt(this.firstTranslation);
        Object object = CENTERED_HTML_START;
        object = (String)object + string + OPENING_BRACE_TEXT;
        object = (String)object + string2 + CLOSING_BRACE_TEXT + string3;
        object = (String)object + CENTERED_HTML_END;
        return object;
    }

    private String createThreeLinesTextWithKanji() {
        String string = BIG_BOLD_START + HtmlTool.encodeHtmlOnlyLtGt(this.kanji) + BOLD_END;
        String string2 = NORMAL_BOLD_START + HtmlTool.encodeHtmlOnlyLtGt(this.kana) + BOLD_END;
        String string3 = HtmlTool.encodeHtmlOnlyLtGt(this.romaji);
        String string4 = HtmlTool.encodeHtmlOnlyLtGt(this.firstTranslation);
        Object object = CENTERED_HTML_START;
        object = (String)object + string + "<br/>";
        object = (String)object + "(" + string2 + ", " + string3 + ")<br/>";
        object = (String)object + string4;
        object = (String)object + CENTERED_HTML_END;
        return object;
    }

    private String createThreeLinesTextWithoutKanji() {
        String string = BIG_BOLD_START + HtmlTool.encodeHtmlOnlyLtGt(this.kana) + BOLD_END;
        String string2 = HtmlTool.encodeHtmlOnlyLtGt(this.romaji);
        String string3 = HtmlTool.encodeHtmlOnlyLtGt(this.firstTranslation);
        Object object = CENTERED_HTML_START;
        object = (String)object + string + "<br/>";
        object = (String)object + "(" + string2 + ")<br/>";
        object = (String)object + string3;
        object = (String)object + CENTERED_HTML_END;
        return object;
    }

    private String createFourLinesTextWithKanji() {
        String string = BIG_BOLD_START + HtmlTool.encodeHtmlOnlyLtGt(this.kanji) + BOLD_END;
        String string2 = NORMAL_BOLD_START + HtmlTool.encodeHtmlOnlyLtGt(this.kana) + BOLD_END;
        String string3 = HtmlTool.encodeHtmlOnlyLtGt(this.romaji);
        String string4 = HtmlTool.encodeHtmlOnlyLtGt(this.firstTranslation);
        Object object = CENTERED_HTML_START;
        object = (String)object + string + "<br/>";
        object = (String)object + "(" + string2 + ",<br/>";
        object = (String)object + string3 + ")<br/>";
        object = (String)object + string4;
        object = (String)object + CENTERED_HTML_END;
        return object;
    }

    private String createLongerTextWithKanji() {
        List<String> list = this.splitLongText(this.kanji);
        List<String> list2 = this.splitLongText(this.kana);
        List<String> list3 = this.splitLongText(this.romaji);
        List<String> list4 = this.splitLongText(this.firstTranslation);
        Object object = this.encodeHtmlOnlyLtGtAndJoinWithBr(list);
        Object object2 = this.encodeHtmlOnlyLtGtAndJoinWithBr(list2);
        String string = this.encodeHtmlOnlyLtGtAndJoinWithBr(list3);
        String string2 = this.encodeHtmlOnlyLtGtAndJoinWithBr(list4);
        object = BIG_BOLD_START + (String)object + BOLD_END;
        object2 = NORMAL_BOLD_START + (String)object2 + BOLD_END;
        Object object3 = CENTERED_HTML_START;
        object3 = (String)object3 + (String)object + "<br/>";
        object3 = (String)object3 + "(" + (String)object2 + ",<br/>";
        object3 = (String)object3 + string + ")<br/>";
        object3 = (String)object3 + string2;
        object3 = (String)object3 + CENTERED_HTML_END;
        return object3;
    }

    private List<String> splitLongText(String string) {
        String string2 = Text.addLineBreaks(string, 35);
        return Text.splitByLineBreaks(string2);
    }

    private String encodeHtmlOnlyLtGtAndJoinWithBr(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            String string2 = HtmlTool.encodeHtmlOnlyLtGt(string);
            arrayList.add(string2);
        }
        return Text.join("<br/>", arrayList);
    }

    private String createLongerTextWithoutKanji() {
        List<String> list = this.splitLongText(this.kana);
        List<String> list2 = this.splitLongText(this.romaji);
        List<String> list3 = this.splitLongText(this.firstTranslation);
        Object object = this.encodeHtmlOnlyLtGtAndJoinWithBr(list);
        String string = this.encodeHtmlOnlyLtGtAndJoinWithBr(list2);
        String string2 = this.encodeHtmlOnlyLtGtAndJoinWithBr(list3);
        object = BIG_BOLD_START + (String)object + BOLD_END;
        Object object2 = CENTERED_HTML_START;
        object2 = (String)object2 + (String)object + "<br/>";
        object2 = (String)object2 + "(" + string + ")<br/>";
        object2 = (String)object2 + string2;
        object2 = (String)object2 + CENTERED_HTML_END;
        return object2;
    }

    public String getText() {
        return this.text;
    }
}

