/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.creation.menu;

import de.duehl.swing.ui.menu.MyMenuItem;
import de.duehl.swing.ui.menu.SingleMenuCreation;
import de.duehl.vocabulary.japanese.ui.VocabularyTrainerGui;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class VocableMenuCreation
implements SingleMenuCreation {
    private final VocabularyTrainerGui gui;

    public VocableMenuCreation(VocabularyTrainerGui vocabularyTrainerGui) {
        this.gui = vocabularyTrainerGui;
    }

    @Override
    public JMenu createTheMenu() {
        JMenu jMenu = new JMenu("Vokabeln");
        jMenu.setMnemonic('v');
        jMenu.add(this.createSearchVocablesMenuItem());
        jMenu.add(this.createComplexSearchVocablesMenuItem());
        jMenu.addSeparator();
        jMenu.add(this.createShowAllVocablesWithASpecificSearchWordMenuItem());
        jMenu.add(this.createShowAllVocablesWithASpecificPartOfSpeachMenuItem());
        jMenu.addSeparator();
        jMenu.add(this.createShowAllVocablesAsListMenuItem());
        jMenu.add(this.createShowAllVocablesAsSheetMenuItem());
        jMenu.add(this.createTestAllVocablesMenuItem());
        jMenu.addSeparator();
        jMenu.add(this.createSelectAllVocabulariesOnViewedTabMenuItem());
        jMenu.add(this.createDeselectAllVocabulariesOnViewedTabMenuItem());
        jMenu.add(this.createShowSelectedVocabulariesOnViewedTabMenuItem());
        jMenu.add(this.createTest10RandomVocablesFromSelectedVocabulariesOnViewedTabMenuItem());
        jMenu.add(this.createTestSelectedVocabulariesOnViewedTabMenuItem());
        jMenu.addSeparator();
        jMenu.add(this.createTest10RandomVocablesMenuItem());
        jMenu.addSeparator();
        jMenu.add(this.createShowNotTestedVocablesMenuItem());
        jMenu.add(this.createShowNotTestedVocablesAsSheetMenuItem());
        jMenu.add(this.createShowNotTestedVocablesAsListMenuItem());
        jMenu.add(this.createTestNotTestedVocablesMenuItem());
        jMenu.addSeparator();
        jMenu.add(this.createShowNotCorrectTestedVocablesMenuItem());
        jMenu.add(this.createTestNotCorrectTestedVocablesMenuItem());
        jMenu.addSeparator();
        jMenu.add(this.createShowNotTestedForAWhileVocablesMenuItem());
        jMenu.add(this.createTestNotTestedForAWhileVocablesMenuItem());
        jMenu.addSeparator();
        jMenu.add(this.createShowNotCorrectTestedForAWhileVocablesMenuItem());
        jMenu.add(this.createTestNotCorrectTestedForAWhileVocablesMenuItem());
        jMenu.addSeparator();
        jMenu.add(this.createShowNewestVocablesMenuItem());
        jMenu.add(this.createShowNewestVocablesAsSheetMenuItem());
        jMenu.add(this.createShowNewestVocablesAsListMenuItem());
        jMenu.add(this.createTestNewestVocablesMenuItem());
        return jMenu;
    }

    private JMenuItem createSearchVocablesMenuItem() {
        return new MyMenuItem("Vokabeln suchen (einfach) ...").mnemonic('s').accelerator(70, 128).actionListener(actionEvent -> this.gui.vocableSearch());
    }

    private JMenuItem createComplexSearchVocablesMenuItem() {
        return new MyMenuItem("Vokabeln suchen (erweitert) ...").mnemonic('e').accelerator(70, 192).actionListener(actionEvent -> this.gui.complexVocableSearch());
    }

    private JMenuItem createShowAllVocablesWithASpecificSearchWordMenuItem() {
        return new MyMenuItem("Alle Vokabeln mit einem bestimmten Suchbegriff anzeigen ...").accelerator(117, 0).actionListener(actionEvent -> this.gui.showAllVocablesWithASpecificSearchWord());
    }

    private JMenuItem createShowAllVocablesWithASpecificPartOfSpeachMenuItem() {
        return new MyMenuItem("Alle Vokabeln mit einer bestimmten Wortart anzeigen ...").accelerator(118, 0).actionListener(actionEvent -> this.gui.showAllAllVocablesWithASpecificPartOfSpeach());
    }

    private JMenuItem createShowAllVocablesAsListMenuItem() {
        return new MyMenuItem("Alle Vokabeln als Liste anzeigen ...").actionListener(actionEvent -> this.gui.showAllVocablesAsList());
    }

    private JMenuItem createShowAllVocablesAsSheetMenuItem() {
        return new MyMenuItem("Alle Vokabeln als Blatt anzeigen ...").actionListener(actionEvent -> this.gui.showAllVocablesAsSheet());
    }

    private JMenuItem createTestAllVocablesMenuItem() {
        return new MyMenuItem("Alle Vokabeln abfragen ...").actionListener(actionEvent -> this.gui.testAllVocabularies());
    }

    private JMenuItem createSelectAllVocabulariesOnViewedTabMenuItem() {
        return new MyMenuItem("Alle Vokabularien im aktuellen Reiter ausw\u00e4hlen").actionListener(actionEvent -> this.gui.selectAllVocabulariesInTab());
    }

    private JMenuItem createDeselectAllVocabulariesOnViewedTabMenuItem() {
        return new MyMenuItem("Alle Vokabularien im aktuellen Reiter abw\u00e4hlen").actionListener(actionEvent -> this.gui.deselectAllVocabulariesInTab());
    }

    private JMenuItem createShowSelectedVocabulariesOnViewedTabMenuItem() {
        return new MyMenuItem("Alle Vokabeln der ausgew\u00e4hlten Vokabularien anzeigen ...").actionListener(actionEvent -> this.gui.listSelectedVocabularies());
    }

    private JMenuItem createTest10RandomVocablesFromSelectedVocabulariesOnViewedTabMenuItem() {
        return new MyMenuItem("Zehn zuf\u00e4llige Vokabeln der ausgew\u00e4hlten Vokabularien anzeigen ...").actionListener(actionEvent -> this.gui.test10RandomVocablesFromSelectedVocabularies());
    }

    private JMenuItem createTestSelectedVocabulariesOnViewedTabMenuItem() {
        return new MyMenuItem("Alle Vokabeln der ausgew\u00e4hlten Vokabularien abfragen ...").actionListener(actionEvent -> this.gui.testSelectedVocabularies());
    }

    private JMenuItem createTest10RandomVocablesMenuItem() {
        return new MyMenuItem("Zehn zuf\u00e4llige Vokabeln abfragen ...").accelerator(119, 0).actionListener(actionEvent -> this.gui.test10RandomVocables());
    }

    private JMenuItem createShowNotTestedVocablesMenuItem() {
        return new MyMenuItem("Noch nicht abgefragte Vokabeln anzeigen ...").mnemonic('z').actionListener(actionEvent -> this.gui.showNotTestedVocables());
    }

    private JMenuItem createShowNotTestedVocablesAsSheetMenuItem() {
        return new MyMenuItem("Noch nicht abgefragte Vokabeln als Blatt anzeigen ...").mnemonic('z').actionListener(actionEvent -> this.gui.showNotTestedVocablesAsSheet());
    }

    private JMenuItem createShowNotTestedVocablesAsListMenuItem() {
        return new MyMenuItem("Noch nicht abgefragte Vokabeln als Liste anzeigen ...").mnemonic('z').actionListener(actionEvent -> this.gui.showNotTestedVocablesAsList());
    }

    private JMenuItem createTestNotTestedVocablesMenuItem() {
        return new MyMenuItem("Noch nicht abgefragte Vokabeln abfragen").mnemonic('n').accelerator(85, 128).actionListener(actionEvent -> this.gui.testNotTestedVocables());
    }

    private JMenuItem createShowNotCorrectTestedVocablesMenuItem() {
        return new MyMenuItem("Noch nicht korrekt \u00fcbersetzte Vokabeln anzeigen").actionListener(actionEvent -> this.gui.showNotCorrectTestedVocables());
    }

    private JMenuItem createTestNotCorrectTestedVocablesMenuItem() {
        return new MyMenuItem("Noch nicht korrekt \u00fcbersetzte Vokabeln abfragen").actionListener(actionEvent -> this.gui.testNotCorrectTestedVocables());
    }

    private JMenuItem createShowNotTestedForAWhileVocablesMenuItem() {
        return new MyMenuItem("Lange nicht mehr abgefragte Vokabeln anzeigen").actionListener(actionEvent -> this.gui.showNotTestedForAWhileVocables());
    }

    private JMenuItem createTestNotTestedForAWhileVocablesMenuItem() {
        return new MyMenuItem("Lange nicht mehr abgefragte Vokabeln abfragen").actionListener(actionEvent -> this.gui.testNotTestedForAWhileVocables());
    }

    private JMenuItem createShowNotCorrectTestedForAWhileVocablesMenuItem() {
        return new MyMenuItem("Lange nicht mehr korrekt \u00fcbersetzte Vokabeln anzeigen").actionListener(actionEvent -> this.gui.showNotCorrectTestedForAWhileVocables());
    }

    private JMenuItem createTestNotCorrectTestedForAWhileVocablesMenuItem() {
        return new MyMenuItem("Lange nicht mehr korrekt \u00fcbersetzte Vokabeln abfragen").actionListener(actionEvent -> this.gui.testNotCorrectTestedForAWhileVocables());
    }

    private JMenuItem createShowNewestVocablesMenuItem() {
        return new MyMenuItem("Neuste Vokabeln anzeigen").actionListener(actionEvent -> this.gui.showNewestVocables());
    }

    private JMenuItem createShowNewestVocablesAsSheetMenuItem() {
        return new MyMenuItem("Neuste Vokabeln als Blatt anzeigen ...").mnemonic('z').actionListener(actionEvent -> this.gui.showNewestVocablesAsSheet());
    }

    private JMenuItem createShowNewestVocablesAsListMenuItem() {
        return new MyMenuItem("Neuste Vokabeln als Liste anzeigen ...").mnemonic('z').actionListener(actionEvent -> this.gui.showNewestVocablesAsList());
    }

    private JMenuItem createTestNewestVocablesMenuItem() {
        return new MyMenuItem("Neuste Vokabeln abfragen").actionListener(actionEvent -> this.gui.testNewestVocables());
    }
}

