/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.grammar.headers;

import de.duehl.basics.io.FileHelper;
import de.duehl.basics.text.Text;
import de.duehl.basics.text.html.HtmlTool;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.components.MultipleElementsPanel;
import de.duehl.swing.ui.components.selections.StringSelection;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.grammar.AdjectiveSearchWords;
import de.duehl.vocabulary.japanese.grammar.VerbSearchWords;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.ui.dialog.grammar.headers.data.GrammarFormAndStringSelection;
import de.duehl.vocabulary.japanese.ui.dialog.grammar.headers.io.GrammarTableOwnHeadersLoader;
import de.duehl.vocabulary.japanese.ui.dialog.grammar.headers.io.GrammarTableOwnHeadersSaver;
import de.duehl.vocabulary.japanese.ui.dialog.grammar.headers.tools.GrammarTableHeaderFieldsToMapCreator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class GrammarTableHeaderEditor
extends ModalDialogBase {
    private static final String EXPLANATION = "Hier werden die \u00dcberschriften f\u00fcr die Erstellung von grammatikalischen Tabellen von\nVerben oder Adjektiven bearbeitet.\n\nStandardm\u00e4\u00dfig werden als die \u00dcberschriften die von mir bei der Vokabelerstellung ver-\ngebenen, l\u00e4nglichen, aber eindeutigen Texte verwendet. F\u00fcr im Unterricht oder zum\nLernen zu verwendenden Tabellen hat man aber vielleicht lieber\n    \"\u3066\u3044\u307e\u3059\"\nals\n    \"h\u00f6fliche Verlaufsform Gegenwart\"\n\u00fcber der Tabelle stehen.\nDaher kann man hier eigene Texte daf\u00fcr vergeben.\n\nDie hier leer gelassenen Felder werden nicht \u00fcberschrieben, sondern behalten die ori-\nginalen, von mir vorgegebenen Inhalte.\n";
    private final Options options;
    private final List<GrammarFormAndStringSelection> verbGrammarFormAndStringSelections;
    private final List<GrammarFormAndStringSelection> iAdjectiveGrammarFormAndStringSelections;
    private final List<GrammarFormAndStringSelection> naAdjectiveGrammarFormAndStringSelections;
    private final JTabbedPane verbOrAdjectiveFormsTabs;
    private final JPanel verbFormsTabPanel;
    private final JPanel iAdjectiveFormsTabPanel;
    private final JPanel naAdjectiveFormsTabPanel;
    private final JPanel explanationTabPanel;
    private boolean ok;
    private List<String> applyProblems;

    public GrammarTableHeaderEditor(Options options, Point point, FumikoUiObjects fumikoUiObjects) {
        super(point, fumikoUiObjects.getProgramImage(), "Erzeugung grammatikalischer Tabllen von Verben oder Adjektiven");
        this.addEscapeBehaviour();
        this.options = options;
        this.verbGrammarFormAndStringSelections = new ArrayList<GrammarFormAndStringSelection>();
        this.iAdjectiveGrammarFormAndStringSelections = new ArrayList<GrammarFormAndStringSelection>();
        this.naAdjectiveGrammarFormAndStringSelections = new ArrayList<GrammarFormAndStringSelection>();
        this.verbOrAdjectiveFormsTabs = new JTabbedPane();
        this.verbFormsTabPanel = new JPanel();
        this.iAdjectiveFormsTabPanel = new JPanel();
        this.naAdjectiveFormsTabPanel = new JPanel();
        this.explanationTabPanel = new JPanel();
        this.init();
        this.fillDialog();
    }

    private void init() {
        this.initVerbFormCheckBoxes();
        this.initIAdjectiveFormCheckBoxes();
        this.initNaAdjectiveFormCheckBoxes();
        this.initMainTabs();
        this.initTabPanels();
    }

    private void initVerbFormCheckBoxes() {
        GrammarTableHeaderEditor.initGrammarFormAndStringSelections(VerbSearchWords.SORTED_VERB_SEARCH_WORDS, this.verbGrammarFormAndStringSelections, this.options.getGrammarTableVerbHeadersMap());
    }

    private void initIAdjectiveFormCheckBoxes() {
        GrammarTableHeaderEditor.initGrammarFormAndStringSelections(AdjectiveSearchWords.SORTED_I_ADJEKTIVE_SEARCH_WORDS, this.iAdjectiveGrammarFormAndStringSelections, this.options.getGrammarTableIAdjectiveHeadersMap());
    }

    private void initNaAdjectiveFormCheckBoxes() {
        GrammarTableHeaderEditor.initGrammarFormAndStringSelections(AdjectiveSearchWords.SORTED_NA_ADJEKTIVE_SEARCH_WORDS, this.naAdjectiveGrammarFormAndStringSelections, this.options.getGrammarTableNaAdjectiveHeadersMap());
    }

    private static void initGrammarFormAndStringSelections(List<String> list, List<GrammarFormAndStringSelection> list2, Map<String, String> map) {
        list2.clear();
        for (String string : list) {
            StringSelection stringSelection = new StringSelection(string);
            String string2 = map.containsKey(string) ? map.get(string) : "";
            stringSelection.setText(string2);
            GrammarFormAndStringSelection grammarFormAndStringSelection = new GrammarFormAndStringSelection(string, stringSelection);
            list2.add(grammarFormAndStringSelection);
        }
    }

    private void initMainTabs() {
        this.verbOrAdjectiveFormsTabs.add("Verbformen", GuiTools.createScrollPane(this.verbFormsTabPanel));
        this.verbOrAdjectiveFormsTabs.add("I-Adjektivformen", GuiTools.createScrollPane(this.iAdjectiveFormsTabPanel));
        this.verbOrAdjectiveFormsTabs.add("NA-Adjektivformen", GuiTools.createScrollPane(this.naAdjectiveFormsTabPanel));
        this.verbOrAdjectiveFormsTabs.add("Erkl\u00e4rung", GuiTools.createScrollPane(this.explanationTabPanel));
    }

    private void initTabPanels() {
        this.initTabPane(this.verbFormsTabPanel, this.verbGrammarFormAndStringSelections);
        this.initTabPane(this.iAdjectiveFormsTabPanel, this.iAdjectiveGrammarFormAndStringSelections);
        this.initTabPane(this.naAdjectiveFormsTabPanel, this.naAdjectiveGrammarFormAndStringSelections);
        this.initExplanationTabPane();
    }

    private void initTabPane(JPanel jPanel, List<GrammarFormAndStringSelection> list) {
        ArrayList<JPanel> arrayList = new ArrayList<JPanel>();
        for (GrammarFormAndStringSelection grammarFormAndStringSelection : list) {
            StringSelection stringSelection = grammarFormAndStringSelection.getStringSelection();
            arrayList.add(stringSelection.getPanel());
        }
        MultipleElementsPanel multipleElementsPanel = new MultipleElementsPanel(arrayList, 3, 5);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)multipleElementsPanel, "Center");
        jPanel.add(this.createDummyWidthPanel(), "South");
    }

    private Component createDummyWidthPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(1000, 0));
        return jPanel;
    }

    private void initExplanationTabPane() {
        this.explanationTabPanel.setLayout(new BorderLayout());
        this.explanationTabPanel.add((Component)GuiTools.center(this.createExplanationPart()), "Center");
    }

    private Component createExplanationPart() {
        String string = HtmlTool.htmlify(EXPLANATION);
        JLabel jLabel = new JLabel(string);
        jLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GuiTools.biggerFont(jLabel, 5);
        return jLabel;
    }

    @Override
    protected void populateDialog() {
        this.add(this.createMainPart(), "Center");
        this.add(this.createButtonPart(), "South");
        this.pack();
    }

    private Component createMainPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.verbOrAdjectiveFormsTabs);
        return jPanel;
    }

    private Component createButtonPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createQuitButton(), "West");
        jPanel.add((Component)GuiTools.centerHorizontal(this.createMiddleButtons()), "Center");
        jPanel.add(this.createOkButton(), "East");
        return jPanel;
    }

    private Component createQuitButton() {
        JButton jButton = new JButton("Abbrechen");
        jButton.addActionListener(actionEvent -> this.closeDialog());
        return jButton;
    }

    private Component createMiddleButtons() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 0, 2, 2));
        jPanel.add(this.createLoadButton());
        jPanel.add(this.createSaveButton());
        jPanel.add(this.createClearAllButton());
        return jPanel;
    }

    private Component createLoadButton() {
        JButton jButton = new JButton("laden");
        jButton.addActionListener(actionEvent -> this.load());
        return jButton;
    }

    private void load() {
        String string = GuiTools.openFile(this.getWindowAsComponent(), "Datei mit den eigenen Tabellen\u00fcberschriften ausw\u00e4hlen", this.options.getGrammarTableLastUsedOwnHeadersDirectory(), GuiTools.createTextFileFilter());
        if (!string.isEmpty()) {
            if (FileHelper.isFile(string)) {
                this.loadExistingFile(string);
                String string2 = FileHelper.getDirName(string);
                this.options.setGrammarTableLastUsedOwnHeadersDirectory(string2);
            } else {
                GuiTools.informUser("Datei nicht gefunden", "Die Datei '" + string + "' wurde nicht gefunden.\nDas Laden wurde abgebrochen.");
            }
        }
    }

    private void loadExistingFile(String string) {
        GrammarTableOwnHeadersLoader grammarTableOwnHeadersLoader = new GrammarTableOwnHeadersLoader(string);
        grammarTableOwnHeadersLoader.load();
        Map<String, String> map = grammarTableOwnHeadersLoader.getVerbHeadersMap();
        Map<String, String> map2 = grammarTableOwnHeadersLoader.getIAdjectiveHeadersMap();
        Map<String, String> map3 = grammarTableOwnHeadersLoader.getNaAdjectiveHeadersMap();
        this.fillNewTexts(this.verbGrammarFormAndStringSelections, map);
        this.fillNewTexts(this.iAdjectiveGrammarFormAndStringSelections, map2);
        this.fillNewTexts(this.naAdjectiveGrammarFormAndStringSelections, map3);
    }

    private void fillNewTexts(List<GrammarFormAndStringSelection> list, Map<String, String> map) {
        for (GrammarFormAndStringSelection grammarFormAndStringSelection : list) {
            StringSelection stringSelection = grammarFormAndStringSelection.getStringSelection();
            String string = stringSelection.getTitle();
            if (map.containsKey(string)) {
                String string2 = map.get(string);
                stringSelection.setText(string2);
                continue;
            }
            stringSelection.setText("");
        }
    }

    private Component createSaveButton() {
        JButton jButton = new JButton("speichern");
        jButton.addActionListener(actionEvent -> this.save());
        return jButton;
    }

    private void save() {
        String string = GuiTools.saveFileAsWithTitle("Wohin soll Datei mit den eigenen Tabellen\u00fcberschriften gespeichert werden?", this.getWindowAsComponent(), this.options.getGrammarTableLastUsedOwnHeadersDirectory(), GuiTools.createTextFileFilter());
        if (!string.isBlank()) {
            boolean bl = false;
            bl = FileHelper.exists(string) ? GuiTools.askUser("Die Datei existiert bereits.", "Die Datei '" + string + "' existiert bereits, soll sie \u00fcberschriben werden?") : true;
            if (bl) {
                this.reallySaveList(string);
                String string2 = FileHelper.getDirName(string);
                this.options.setGrammarTableLastUsedOwnHeadersDirectory(string2);
            }
        }
    }

    private void reallySaveList(String string) {
        GrammarTableOwnHeadersSaver grammarTableOwnHeadersSaver = new GrammarTableOwnHeadersSaver(string, this.verbGrammarFormAndStringSelections, this.iAdjectiveGrammarFormAndStringSelections, this.naAdjectiveGrammarFormAndStringSelections);
        grammarTableOwnHeadersSaver.save();
    }

    private Component createClearAllButton() {
        JButton jButton = new JButton("alle Felder leeren");
        jButton.addActionListener(actionEvent -> this.clearAll());
        return jButton;
    }

    private void clearAll() {
        this.clearAllFilds(this.verbGrammarFormAndStringSelections);
        this.clearAllFilds(this.iAdjectiveGrammarFormAndStringSelections);
        this.clearAllFilds(this.naAdjectiveGrammarFormAndStringSelections);
    }

    private void clearAllFilds(List<GrammarFormAndStringSelection> list) {
        for (GrammarFormAndStringSelection grammarFormAndStringSelection : list) {
            StringSelection stringSelection = grammarFormAndStringSelection.getStringSelection();
            stringSelection.setText("");
        }
    }

    private Component createOkButton() {
        JButton jButton = new JButton("\u00dcberschriften \u00fcbernehmen");
        jButton.addActionListener(actionEvent -> this.apply());
        return jButton;
    }

    private void apply() {
        this.ok = true;
        this.applyProblems = new ArrayList<String>();
        if (this.ok) {
            this.storeVerbFormHeaders();
        }
        if (this.ok) {
            this.storeIAdjectiveFormHeaders();
        }
        if (this.ok) {
            this.storeNaAdjectiveFormHeaders();
        }
        if (this.ok) {
            this.closeDialog();
        } else {
            GuiTools.informUser(this.getWindowAsComponent(), "Die \u00dcberschriften k\u00f6nnen nicht gespeichert werden", Text.join("\n\n", this.applyProblems));
        }
    }

    private void storeVerbFormHeaders() {
        this.storeFormHeaders(this.verbGrammarFormAndStringSelections, this.options.getGrammarTableVerbHeadersMap());
    }

    private void storeIAdjectiveFormHeaders() {
        this.storeFormHeaders(this.iAdjectiveGrammarFormAndStringSelections, this.options.getGrammarTableIAdjectiveHeadersMap());
    }

    private void storeNaAdjectiveFormHeaders() {
        this.storeFormHeaders(this.naAdjectiveGrammarFormAndStringSelections, this.options.getGrammarTableNaAdjectiveHeadersMap());
    }

    private void storeFormHeaders(List<GrammarFormAndStringSelection> list, Map<String, String> map) {
        GrammarTableHeaderFieldsToMapCreator grammarTableHeaderFieldsToMapCreator = new GrammarTableHeaderFieldsToMapCreator(list, map);
        grammarTableHeaderFieldsToMapCreator.create();
        if (!grammarTableHeaderFieldsToMapCreator.isSuccess()) {
            this.ok = false;
            this.applyProblems.addAll(grammarTableHeaderFieldsToMapCreator.getProblems());
        }
    }
}

