/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.kanji.display;

import de.duehl.basics.text.Text;
import de.duehl.swing.ui.components.selections.TextAreaSelection;
import de.duehl.swing.ui.components.selections.tools.SelectionsHelper;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.vocabulary.japanese.data.symbol.Kanji;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;

public class KanjiGermanMeaningAnLesungenPanel {
    private final Kanji kanji;
    private final JPanel panel;
    private final TextAreaSelection germanMeaningSelection;
    private final TextAreaSelection onLesungenSelection;
    private final TextAreaSelection kunLesungenSelection;

    public KanjiGermanMeaningAnLesungenPanel(Kanji kanji) {
        this.kanji = kanji;
        this.panel = new JPanel();
        this.germanMeaningSelection = new TextAreaSelection("Deutsche Bedeutung");
        this.onLesungenSelection = new TextAreaSelection("ON-Lesungen");
        this.kunLesungenSelection = new TextAreaSelection("kun-Lesungen");
        this.init();
        this.createGui();
        this.showKanji();
    }

    private void init() {
        SelectionsHelper.initSelectionAsFocusableViewer(this.germanMeaningSelection);
        SelectionsHelper.initSelectionAsFocusableViewer(this.onLesungenSelection);
        SelectionsHelper.initSelectionAsFocusableViewer(this.kunLesungenSelection);
    }

    private void createGui() {
        this.panel.setLayout(new BorderLayout());
        this.panel.add(this.createGermanMeaningOnLesungenAndKunLesungenPart(), "Center");
    }

    private Component createGermanMeaningOnLesungenAndKunLesungenPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        jPanel.add(this.germanMeaningSelection.getPanel());
        jPanel.add(this.onLesungenSelection.getPanel());
        jPanel.add(this.kunLesungenSelection.getPanel());
        return jPanel;
    }

    private void showKanji() {
        this.germanMeaningSelection.setText(Text.joinWithLineBreak(Text.splitByKomma(this.kanji.getGermanMeaning())));
        this.onLesungenSelection.setText(Text.joinWithLineBreak(this.kanji.getOnLesungen()));
        this.kunLesungenSelection.setText(Text.joinWithLineBreak(this.kanji.getKunLesungen()));
    }

    public Component getPanel() {
        return this.panel;
    }
}

