/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.kanji.kanjitest;

import de.duehl.basics.text.Text;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.components.selections.TextAreaSelection;
import de.duehl.swing.ui.components.selections.tools.SelectionsHelper;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.swing.ui.key.BindKeysOnRootPane;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.vocabulary.japanese.common.color.VocableColors;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.symbol.Kanji;
import de.duehl.vocabulary.japanese.logic.symbol.kanji.test.data.KanjiUserInputType;
import de.duehl.vocabulary.japanese.logic.symbol.kanji.test.data.SingleUserInputKanjiCheckResult;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.ui.dialog.kanji.detail.KanjiDetailDialog;
import de.duehl.vocabulary.japanese.ui.dialog.kanji.display.KanjiGermanMeaningAnLesungenPanel;
import de.duehl.vocabulary.japanese.ui.dialog.kanji.display.KanjiPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class KanjiTestEvaluationDialog
extends ModalDialogBase {
    private static final int MIN_WIDTH = 1400;
    private final SingleUserInputKanjiCheckResult result;
    private final Kanji kanji;
    private final boolean correct;
    private final FumikoDataStructures dataStructures;
    private final FumikoUiObjects uiObjects;
    private final String message;
    private final VocableColors vocableColors;
    private final Color backgroundColor;
    private final KanjiPanel kanjiPanel;
    private final KanjiGermanMeaningAnLesungenPanel kanjiGermanMeaningAnLesungenPanel;
    private final JButton quitButton;
    private boolean onlyTypingError;
    private final TextAreaSelection userInputGermanMeaningSelection;
    private final TextAreaSelection userInputOnLesungenSelection;
    private final TextAreaSelection userInputKunLesungenSelection;
    private final TextAreaSelection errorMessageSelection;
    private final TextAreaSelection memorandumSelection;
    private boolean errorFilled;
    private boolean memorandumFilled;

    public KanjiTestEvaluationDialog(SingleUserInputKanjiCheckResult singleUserInputKanjiCheckResult, String string, String string2, String string3, FumikoDataStructures fumikoDataStructures, FumikoUiObjects fumikoUiObjects, Point point) {
        super(point, fumikoUiObjects.getProgramImage(), singleUserInputKanjiCheckResult.isOk() ? "Richtig!" : "Leider falsch");
        this.addEscapeBehaviour();
        this.result = singleUserInputKanjiCheckResult;
        this.kanji = singleUserInputKanjiCheckResult.getKanji();
        this.correct = singleUserInputKanjiCheckResult.isOk();
        this.dataStructures = fumikoDataStructures;
        this.uiObjects = fumikoUiObjects;
        this.onlyTypingError = false;
        this.message = this.correct ? "Richtig beantwortet, sehr gut!" : "Das war leider nicht richtig";
        this.vocableColors = new VocableColors(fumikoDataStructures.getOptions());
        this.backgroundColor = this.correct ? this.vocableColors.getSuccessColor() : this.vocableColors.getFailureColor();
        this.quitButton = new JButton("Beenden");
        this.kanjiPanel = new KanjiPanel();
        this.kanjiPanel.setBiggerFontSize(200);
        this.kanjiPanel.showKanji(this.kanji);
        this.kanjiPanel.setAfterFontButtonPressedRunnable(() -> this.pack());
        this.kanjiGermanMeaningAnLesungenPanel = new KanjiGermanMeaningAnLesungenPanel(this.kanji);
        this.userInputGermanMeaningSelection = new TextAreaSelection("Eingebene deutsche Bedeutung");
        this.userInputOnLesungenSelection = new TextAreaSelection("Eingebene ON-Lesungen");
        this.userInputKunLesungenSelection = new TextAreaSelection("Eingebene kun-Lesungen");
        this.errorMessageSelection = new TextAreaSelection("Fehlermeldungen");
        this.memorandumSelection = new TextAreaSelection("Hinweise");
        this.init(string, string2, string3);
        this.fillDialog();
    }

    private void init(String string, String string2, String string3) {
        this.initUserInputTextSelections();
        this.fillUserInputTextSelections(string, string2, string3);
        this.initResultTextSelections();
        this.fillResultTextSelections();
        this.initQuitButton();
    }

    private void initUserInputTextSelections() {
        SelectionsHelper.initSelectionAsViewer(this.userInputGermanMeaningSelection);
        SelectionsHelper.initSelectionAsViewer(this.userInputOnLesungenSelection);
        SelectionsHelper.initSelectionAsViewer(this.userInputKunLesungenSelection);
        this.userInputGermanMeaningSelection.setFocusable(true);
        this.userInputOnLesungenSelection.setFocusable(true);
        this.userInputKunLesungenSelection.setFocusable(true);
        Options options = this.dataStructures.getOptions();
        if (options.isColorUserInputAtKanjiTestEvaluationDialog()) {
            this.setUserInputTextSelectionsBackgrounds();
        }
    }

    private void setUserInputTextSelectionsBackgrounds() {
        List<KanjiUserInputType> list = this.result.getWrongKanjiUserInputTypes();
        boolean bl = !list.contains((Object)KanjiUserInputType.GERMAN_MEANING);
        boolean bl2 = !list.contains((Object)KanjiUserInputType.ON_LESUNG);
        boolean bl3 = !list.contains((Object)KanjiUserInputType.KUN_LESUNG);
        Color color = this.getSuccessOrFailureColor(bl);
        Color color2 = this.getSuccessOrFailureColor(bl2);
        Color color3 = this.getSuccessOrFailureColor(bl3);
        this.userInputGermanMeaningSelection.setBackgroundColor(color);
        this.userInputOnLesungenSelection.setBackgroundColor(color2);
        this.userInputKunLesungenSelection.setBackgroundColor(color3);
    }

    private Color getSuccessOrFailureColor(boolean bl) {
        if (bl) {
            return this.vocableColors.getSuccessColor();
        }
        return this.vocableColors.getFailureColor();
    }

    private void fillUserInputTextSelections(String string, String string2, String string3) {
        int n = Text.splitByKomma(this.kanji.getGermanMeaning()).size();
        int n2 = this.kanji.getOnLesungen().size();
        int n3 = this.kanji.getKunLesungen().size();
        String string4 = this.splitByKomma(string, n);
        String string5 = this.splitBySpaceOrKomma(string2, n2);
        String string6 = this.splitBySpaceOrKomma(string3, n3);
        this.userInputGermanMeaningSelection.setText(string4);
        this.userInputOnLesungenSelection.setText(string5);
        this.userInputKunLesungenSelection.setText(string6);
    }

    private String splitByKomma(String string, int n) {
        List<String> list = Text.splitByKomma(string);
        return this.joinWithLineBreak(list, n);
    }

    private String splitBySpaceOrKomma(String string, int n) {
        List<String> list = Text.splitBy(string, " *, *| +");
        return this.joinWithLineBreak(list, n);
    }

    private String joinWithLineBreak(List<String> list, int n) {
        while (list.size() < n) {
            list.add("");
        }
        return Text.joinWithLineBreak(list);
    }

    private void initResultTextSelections() {
        SelectionsHelper.initSelectionAsViewer(this.errorMessageSelection);
        SelectionsHelper.initSelectionAsViewer(this.memorandumSelection);
    }

    private void fillResultTextSelections() {
        String string = this.result.getErrorDescription();
        String string2 = this.result.getMemorandum();
        this.errorMessageSelection.setText(string);
        this.memorandumSelection.setText(string2);
        this.errorFilled = !string.isBlank();
        this.memorandumFilled = !string2.isBlank();
    }

    private void initQuitButton() {
        GuiTools.addReturnListener(this.quitButton, () -> this.quitButton.doClick());
    }

    @Override
    protected void populateDialog() {
        this.add(this.createCenterPart(), "Center");
        this.add(this.createButtonsPart(), "South");
        if (!this.correct) {
            this.keybindingsForOnlyTypingError();
        }
        this.keybindingsForDetailDialog();
        SwingUtilities.invokeLater(() -> this.quitButton.requestFocus());
        this.pack();
    }

    private Component createCenterPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createMessagePart(), "North");
        jPanel.add(this.createBigCenterPart(), "Center");
        return jPanel;
    }

    private Component createMessagePart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle(jPanel);
        jPanel.add(this.createMessageLabel(), "Center");
        return jPanel;
    }

    private Component createMessageLabel() {
        JLabel jLabel = new JLabel(this.message);
        jLabel.setHorizontalAlignment(0);
        jLabel.setPreferredSize(new Dimension(1400, 30));
        GuiTools.biggerFont(jLabel, 7);
        jLabel.setOpaque(true);
        jLabel.setBackground(this.backgroundColor);
        return jLabel;
    }

    private Component createBigCenterPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        jPanel.add(this.createLeftBigCenterPart());
        jPanel.add(this.createRightBigCenterPart());
        return jPanel;
    }

    private Component createLeftBigCenterPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 0, 2, 2));
        jPanel.add(this.createUpperLeftBigCenterPart());
        jPanel.add(this.createUpperRightBigCenterPart());
        return jPanel;
    }

    private Component createRightBigCenterPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 0, 2, 2));
        jPanel.add(this.createLowerLeftBigCenterPart());
        jPanel.add(this.createLowerRightBigCenterPart());
        return jPanel;
    }

    private Component createUpperLeftBigCenterPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GuiTools.createBlueTitle("Daten zum abgefragten Kanji:", jPanel);
        jPanel.add((Component)this.kanjiPanel.getPanel(), "North");
        return jPanel;
    }

    private Component createUpperRightBigCenterPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        if (this.errorFilled || this.memorandumFilled) {
            jPanel.add(this.createErrorMessageAndMemorandumPart(), "North");
        }
        return jPanel;
    }

    private Component createLowerLeftBigCenterPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GuiTools.createBlueTitle("Daten zum abgefragten Kanji:", jPanel);
        jPanel.add(this.kanjiGermanMeaningAnLesungenPanel.getPanel(), "South");
        return jPanel;
    }

    private Component createLowerRightBigCenterPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createUserDataPart(), "South");
        return jPanel;
    }

    private Component createErrorMessageAndMemorandumPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        GuiTools.createBlueTitle("Anmerkungen:", jPanel);
        if (this.errorFilled) {
            jPanel.add(this.createErrorMessagePart());
        }
        if (this.memorandumFilled) {
            jPanel.add(this.createMemorandumPart());
        }
        return jPanel;
    }

    private Component createUserDataPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        GuiTools.createBlueTitle("Vom Benutzer eingegebene Daten:", jPanel);
        jPanel.add(this.userInputGermanMeaningSelection.getPanel());
        jPanel.add(this.userInputOnLesungenSelection.getPanel());
        jPanel.add(this.userInputKunLesungenSelection.getPanel());
        return jPanel;
    }

    private Component createErrorMessagePart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        jPanel.add(this.errorMessageSelection.getPanel());
        return jPanel;
    }

    private Component createMemorandumPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        jPanel.add(this.memorandumSelection.getPanel());
        return jPanel;
    }

    private Component createButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createDetailButton(), "West");
        if (!this.correct) {
            jPanel.add((Component)GuiTools.centerHorizontal(this.createOnlyTypingErrorLabel()), "Center");
        }
        jPanel.add(this.createQuitButton(), "East");
        return jPanel;
    }

    private Component createDetailButton() {
        JButton jButton = new JButton("Details anzeigen");
        jButton.addActionListener(actionEvent -> this.showDetails());
        return jButton;
    }

    private void showDetails() {
        KanjiDetailDialog kanjiDetailDialog = new KanjiDetailDialog(this.kanji, this.dataStructures, this.uiObjects, this.uiObjects.getInformer(), this.getLocation());
        kanjiDetailDialog.setVisible(true);
    }

    private void keybindingsForDetailDialog() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(68, 128);
        String string = "Strg-D";
        AbstractAction abstractAction = BindKeysOnRootPane.runnableToAction(() -> this.showDetails());
        JRootPane jRootPane = this.getRootPane();
        InputMap inputMap = jRootPane.getInputMap(2);
        inputMap.put(keyStroke, string);
        jRootPane.getActionMap().put(string, abstractAction);
    }

    private Component createOnlyTypingErrorLabel() {
        JLabel jLabel = new JLabel("War es nur ein Tippfehler? Dann Strg-Shift-K dr\u00fccken.");
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        return jLabel;
    }

    private Component createQuitButton() {
        this.quitButton.addActionListener(actionEvent -> this.closeDialog());
        this.quitButton.setBackground(this.backgroundColor);
        return this.quitButton;
    }

    private void keybindingsForOnlyTypingError() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(75, 192);
        String string = "Strg-Shift-K";
        AbstractAction abstractAction = BindKeysOnRootPane.runnableToAction(() -> this.setToOnlyTypingError());
        JRootPane jRootPane = this.getRootPane();
        InputMap inputMap = jRootPane.getInputMap(2);
        inputMap.put(keyStroke, string);
        jRootPane.getActionMap().put(string, abstractAction);
    }

    private void setToOnlyTypingError() {
        String string = "War es nur ein Tippfehler?";
        String string2 = "War die falsche Eingabe wirklich nur ein Tippfehler?\nBitte gewissenhaft antworten und sich nicht selbst bel\u00fcgen.";
        this.onlyTypingError = GuiTools.askUser(this.getWindowAsComponent(), string, string2);
        if (this.onlyTypingError) {
            this.closeDialog();
        }
    }

    public boolean wasOnlyTypingError() {
        return this.onlyTypingError;
    }
}

