/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.options.colors.eleven;

import de.duehl.swing.ui.GuiTools;
import de.duehl.vocabulary.japanese.common.color.VocableColors;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class OneOfElevenColorUi {
    private final String title;
    private Color color;
    private final VocableColors vocableColors;
    private final JPanel panel;
    private final JLabel titleLabel;
    private final JLabel foregroundExampleLabel;
    private final JPanel backgroundExamplePanel;

    public OneOfElevenColorUi(String string, Color color, VocableColors vocableColors) {
        this.title = string;
        this.color = color;
        this.vocableColors = vocableColors;
        this.panel = new JPanel();
        this.titleLabel = new JLabel(string);
        this.foregroundExampleLabel = new JLabel("  Vordergrund  ");
        this.backgroundExamplePanel = new JPanel();
        this.init();
        this.createUi();
    }

    private void init() {
        GuiTools.biggerFont(this.titleLabel, 5);
        this.titleLabel.setOpaque(true);
        this.titleLabel.setBackground(Color.WHITE);
        this.titleLabel.setHorizontalAlignment(0);
        GuiTools.biggerFont(this.foregroundExampleLabel, 5);
        this.actualiseColors();
    }

    private void createUi() {
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this.titleLabel, "Center");
        this.panel.add(this.createColorExamplePartAndChangeButton(), "East");
    }

    private Component createColorExamplePartAndChangeButton() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createColorExamplePart(), "Center");
        jPanel.add(this.createColorChangeButton(), "East");
        return jPanel;
    }

    private Component createColorExamplePart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 2, 2, 2));
        jPanel.add(this.foregroundExampleLabel);
        jPanel.add(this.backgroundExamplePanel);
        return jPanel;
    }

    private Component createColorChangeButton() {
        JButton jButton = new JButton("Farbe \u00e4ndern");
        jButton.addActionListener(actionEvent -> this.changeColor());
        return jButton;
    }

    private void changeColor() {
        Color color = JColorChooser.showDialog(this.panel, this.title + " festlegen", this.color);
        if (null != color) {
            this.color = color;
            this.actualiseColors();
        }
    }

    private void colorTitleLabel() {
        this.titleLabel.setForeground(this.color);
    }

    private void colorForegroundExampleLabel() {
        this.foregroundExampleLabel.setForeground(this.vocableColors.createForegroundColor(this.color));
    }

    private void colorBackgroundExamplePanel() {
        this.backgroundExamplePanel.setBackground(this.vocableColors.createBackgroundColor(this.color));
    }

    private void actualiseColors() {
        this.colorTitleLabel();
        this.colorForegroundExampleLabel();
        this.colorBackgroundExamplePanel();
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public Color getColor() {
        return this.color;
    }
}

