/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.options.colors.vocable;

import de.duehl.swing.persistance.ColorOptionUi;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.vocabulary.japanese.VocabularyTrainerVersion;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JPanel;

public class VocableColorsOptionsUi {
    private final JPanel panel = new JPanel();
    private ColorOptionUi vocableColorStandard;
    private ColorOptionUi vocableColorKanji;
    private ColorOptionUi vocableColorKana;
    private ColorOptionUi vocableColorTranslation;
    private ColorOptionUi vocableColorComment;
    private ColorOptionUi vocableColorSearchWords;
    private ColorOptionUi vocableColorPartOfSpeach;
    private ColorOptionUi vocableColorRomaji;
    private ColorOptionUi vocableColorPronunciation;

    public void initWithOptions(Options options) {
        this.initColorUis(options);
        this.buildPanel();
        this.panel.validate();
        this.panel.invalidate();
        this.panel.repaint();
    }

    private void initColorUis(Options options) {
        this.vocableColorStandard = new ColorOptionUi("Standard", options.getVocableColorStandard());
        this.vocableColorKanji = new ColorOptionUi("Kanji", options.getVocableColorKanji());
        this.vocableColorKana = new ColorOptionUi("Kana", options.getVocableColorKana());
        this.vocableColorRomaji = new ColorOptionUi("Romaji", options.getVocableColorRomaji());
        this.vocableColorPronunciation = new ColorOptionUi("Aussprache", options.getVocableColorPronunciation());
        this.vocableColorTranslation = new ColorOptionUi("\u00dcbersetzung", options.getVocableColorTranslation());
        this.vocableColorComment = new ColorOptionUi("Kommentar", options.getVocableColorComment());
        this.vocableColorSearchWords = new ColorOptionUi("Suchbegriff", options.getVocableColorSearchWords());
        this.vocableColorPartOfSpeach = new ColorOptionUi("Wortart", options.getVocableColorPartOfSpeach());
    }

    private void buildPanel() {
        this.panel.setLayout(new BorderLayout());
        this.panel.add(this.createColorsPart(), "Center");
        this.panel.add(this.createButtonPart(), "South");
    }

    private Component createColorsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(5, 3));
        jPanel.add(this.vocableColorStandard.getPanel());
        jPanel.add(this.vocableColorKanji.getPanel());
        jPanel.add(this.vocableColorKana.getPanel());
        jPanel.add(this.vocableColorRomaji.getPanel());
        jPanel.add(this.vocableColorPronunciation.getPanel());
        jPanel.add(this.vocableColorTranslation.getPanel());
        jPanel.add(this.vocableColorComment.getPanel());
        jPanel.add(this.vocableColorSearchWords.getPanel());
        jPanel.add(this.vocableColorPartOfSpeach.getPanel());
        return jPanel;
    }

    private Component createButtonPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createToDefaultColorsButton(), "West");
        return jPanel;
    }

    private Component createToDefaultColorsButton() {
        JButton jButton = new JButton("Standardfarben");
        jButton.addActionListener(actionEvent -> this.toDefaultColors());
        return jButton;
    }

    private void toDefaultColors() {
        Options options = new Options(new VocabularyTrainerVersion().getVersion());
        this.vocableColorStandard.setColor(options.getVocableColorStandard());
        this.vocableColorKanji.setColor(options.getVocableColorKanji());
        this.vocableColorKana.setColor(options.getVocableColorKana());
        this.vocableColorRomaji.setColor(options.getVocableColorRomaji());
        this.vocableColorPronunciation.setColor(options.getVocableColorPronunciation());
        this.vocableColorTranslation.setColor(options.getVocableColorTranslation());
        this.vocableColorComment.setColor(options.getVocableColorComment());
        this.vocableColorSearchWords.setColor(options.getVocableColorSearchWords());
        this.vocableColorPartOfSpeach.setColor(options.getVocableColorPartOfSpeach());
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public Color getVocableColorStandard() {
        return this.vocableColorStandard.getColor();
    }

    public Color getVocableColorKanji() {
        return this.vocableColorKanji.getColor();
    }

    public Color getVocableColorKana() {
        return this.vocableColorKana.getColor();
    }

    public Color getVocableColorRomaji() {
        return this.vocableColorRomaji.getColor();
    }

    public Color getVocableColorPronunciation() {
        return this.vocableColorPronunciation.getColor();
    }

    public Color getVocableColorTranslation() {
        return this.vocableColorTranslation.getColor();
    }

    public Color getVocableColorComment() {
        return this.vocableColorComment.getColor();
    }

    public Color getVocableColorSearchWords() {
        return this.vocableColorSearchWords.getColor();
    }

    public Color getVocableColorPartOfSpeach() {
        return this.vocableColorPartOfSpeach.getColor();
    }

    public void setIntoOptions(Options options) {
        options.setVocableColorStandard(this.getVocableColorStandard());
        options.setVocableColorKanji(this.getVocableColorKanji());
        options.setVocableColorKana(this.getVocableColorKana());
        options.setVocableColorTranslation(this.getVocableColorTranslation());
        options.setVocableColorComment(this.getVocableColorComment());
        options.setVocableColorSearchWords(this.getVocableColorSearchWords());
        options.setVocableColorPartOfSpeach(this.getVocableColorPartOfSpeach());
        options.setVocableColorRomaji(this.getVocableColorRomaji());
        options.setVocableColorPronunciation(this.getVocableColorPronunciation());
    }
}

