/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.update.bar;

import de.duehl.swing.ui.GuiTools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GroupBar {
    private final String groupName;
    private final String groupDescription;
    private final int version;
    private final boolean isNewOrActualised;
    private final boolean showNewOrActualised;
    private final boolean initialInterestedId;
    private final JPanel panel;
    private final JCheckBox newOrActualisedCheckbox;
    private final JCheckBox interestedCheckbox;
    private final JCheckBox downloadCheckbox;

    public GroupBar(String string, String string2, int n, boolean bl, boolean bl2, boolean bl3) {
        this.groupName = string;
        this.groupDescription = string2;
        this.version = n;
        this.isNewOrActualised = bl;
        this.showNewOrActualised = bl2;
        this.initialInterestedId = bl3;
        this.panel = new JPanel();
        this.newOrActualisedCheckbox = new JCheckBox("Neu oder aktualisiert");
        this.interestedCheckbox = new JCheckBox("Interesse");
        this.downloadCheckbox = new JCheckBox("Download");
        this.initElements();
        this.createGui();
    }

    private void initElements() {
        this.panel.setLayout(new BorderLayout());
        GuiTools.createTitle(this.panel);
        this.newOrActualisedCheckbox.setSelected(this.isNewOrActualised);
        this.newOrActualisedCheckbox.setEnabled(false);
        this.interestedCheckbox.setSelected(this.initialInterestedId);
        this.downloadCheckbox.setSelected(this.initialInterestedId && this.isNewOrActualised);
    }

    private void createGui() {
        this.panel.add(this.createNameAndVersionPart(), "Center");
        this.panel.add(this.createNewInterestedAnDownloadPart(), "East");
    }

    private Component createNameAndVersionPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 15, 0));
        JLabel jLabel = new JLabel(this.groupDescription);
        GuiTools.biggerFont(jLabel, 7);
        jPanel.add(jLabel);
        JLabel jLabel2 = new JLabel("Version " + this.version);
        GuiTools.biggerFont(jLabel, -2);
        jPanel.add(jLabel2);
        if (this.isNewOrActualised && this.showNewOrActualised) {
            jLabel.setForeground(Color.RED);
            jLabel2.setForeground(Color.RED);
        }
        return jPanel;
    }

    private Component createNewInterestedAnDownloadPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 10, 0));
        if (this.showNewOrActualised) {
            // empty if block
        }
        jPanel.add(this.interestedCheckbox);
        jPanel.add(this.downloadCheckbox);
        return jPanel;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public boolean isInterested() {
        return this.interestedCheckbox.isSelected();
    }

    public boolean download() {
        return this.downloadCheckbox.isSelected();
    }
}

