/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.vocables.sheet;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.text.NumberString;
import de.duehl.swing.logic.LongTimeProcessInformer;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.components.MultipleElementsPanel;
import de.duehl.swing.ui.dialogs.base.NonModalFrameDialogBase;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.ui.components.button.OtherViewButtonPanel;
import de.duehl.vocabulary.japanese.ui.components.button.ViewButtonPressedReactor;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.ui.tools.VocabularyTrainerUiTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class VocabularySheetDialog
extends NonModalFrameDialogBase
implements ViewButtonPressedReactor {
    private static final Dimension DIALOG_DIMENSION = new Dimension(1500, 900);
    private static final int DEFAULT_NUMBER_OF_VOCABLES_IN_ONE_ROW = 3;
    private static final List<Integer> POSSIBLE_COLUMNS = CollectionsHelper.buildListFrom(1, 2, 3, 4);
    private final FumikoDataStructures dataStructures;
    private final OtherViewButtonPanel otherViewPanel;
    private JScrollPane vocablesScrollPane;
    private final JPanel vocablesJPanel;
    private int numberOfColumns;
    private final JComboBox<Integer> numberOfColumnsComboBox;
    private final JButton backgroundChangingButton;
    private final List<Component> vocablePanes;

    public VocabularySheetDialog(List<Vocable> list, List<Component> list2, String string, FumikoDataStructures fumikoDataStructures, FumikoUiObjects fumikoUiObjects, LongTimeProcessInformer longTimeProcessInformer, Point point) {
        super(point, fumikoUiObjects.getProgramImage(), VocabularySheetDialog.createDialogTitle(list, string, fumikoDataStructures), DIALOG_DIMENSION);
        this.addEscapeBehaviour();
        this.vocablePanes = list2;
        this.dataStructures = fumikoDataStructures;
        this.vocablesJPanel = new JPanel();
        this.otherViewPanel = new OtherViewButtonPanel(list, this, string, fumikoDataStructures, fumikoUiObjects, longTimeProcessInformer);
        this.otherViewPanel.disableVokabelblattDarstellungButton();
        Options options = fumikoDataStructures.getOptions();
        this.numberOfColumns = options.getNumberOfColumnsOfBlattDarstellung();
        if (this.numberOfColumns < 1) {
            this.numberOfColumns = 3;
        }
        this.numberOfColumnsComboBox = new JComboBox();
        this.backgroundChangingButton = new JButton();
        this.init();
        this.rearrangeVocablePart();
        this.fillDialog();
    }

    private static String createDialogTitle(List<Vocable> list, String string, FumikoDataStructures fumikoDataStructures) {
        String string2 = "Anzeige mit den " + NumberString.taupu(list.size()) + " Vokabeln aus " + string;
        return VocabularyTrainerUiTools.generateTitleWithVocabularyTestSuccesss(list, string2, fumikoDataStructures);
    }

    private void init() {
        this.initVocablesPanel();
        this.initNumberOfColumnsComboBox();
        this.initBackgroundChangingButton();
    }

    private void initVocablesPanel() {
        this.vocablesJPanel.setLayout(new BorderLayout());
    }

    private void initNumberOfColumnsComboBox() {
        this.numberOfColumnsComboBox.setAlignmentX(0.0f);
        this.numberOfColumnsComboBox.setAlignmentY(0.0f);
        ((JLabel)((Object)this.numberOfColumnsComboBox.getRenderer())).setHorizontalAlignment(4);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.addAll(POSSIBLE_COLUMNS);
        if (!POSSIBLE_COLUMNS.contains(this.numberOfColumns)) {
            arrayList.add(this.numberOfColumns);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            this.numberOfColumnsComboBox.addItem(n);
        }
        this.numberOfColumnsComboBox.setSelectedItem(this.numberOfColumns);
        this.numberOfColumnsComboBox.addActionListener(actionEvent -> this.rearrangePageAfterChangedNumbers());
    }

    private void initBackgroundChangingButton() {
        this.setBackgroundChangingButtonTitle();
        this.backgroundChangingButton.addActionListener(actionEvent -> this.toggleBackground());
    }

    private void setBackgroundChangingButtonTitle() {
        Options options = this.dataStructures.getOptions();
        String string = "Hintergrund " + (options.isColorVocableDependingOnLastSuccessWhenViewingVocable() ? "aus" : "ein") + "schalten";
        this.backgroundChangingButton.setText(string);
    }

    private void toggleBackground() {
        Options options = this.dataStructures.getOptions();
        boolean bl = options.isColorVocableDependingOnLastSuccessWhenViewingVocable();
        bl = !bl;
        options.setColorVocableDependingOnLastSuccessWhenViewingVocable(bl);
        this.setBackgroundChangingButtonTitle();
        this.rearrangePageAfterChangedNumbers();
    }

    private void rearrangePageAfterChangedNumbers() {
        this.numberOfColumns = (Integer)this.numberOfColumnsComboBox.getSelectedItem();
        this.rearrangeVocablePart();
        Options options = this.dataStructures.getOptions();
        options.setNumberOfColumnsOfBlattDarstellung(this.numberOfColumns);
    }

    private void rearrangeVocablePart() {
        MultipleElementsPanel<Component> multipleElementsPanel = new MultipleElementsPanel<Component>(this.vocablePanes, this.numberOfColumns, 1);
        this.vocablesScrollPane = GuiTools.createScrollPane(multipleElementsPanel);
        this.vocablesJPanel.removeAll();
        this.vocablesJPanel.add((Component)this.vocablesScrollPane, "Center");
        this.vocablesJPanel.repaint();
        this.vocablesJPanel.validate();
        this.vocablesJPanel.invalidate();
        GuiTools.scrollScrollbarToMinimumLater(this.vocablesScrollPane);
    }

    @Override
    protected void populateDialog() {
        this.add(this.createUpperPart(), "North");
        this.add(this.vocablesJPanel, "Center");
        this.add(this.createButtonsPart(), "South");
    }

    private Component createUpperPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle(jPanel);
        jPanel.add((Component)this.backgroundChangingButton, "West");
        jPanel.add(this.createNumberOfColumnsComboBoxWithTitelPart(), "East");
        return jPanel;
    }

    private Component createNumberOfColumnsComboBoxWithTitelPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JLabel("Anzahl Spalten "), "West");
        jPanel.add(this.numberOfColumnsComboBox, "Center");
        return jPanel;
    }

    private Component createButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createQuitButton(), "East");
        jPanel.add((Component)GuiTools.centerHorizontal(this.otherViewPanel.getPanel()), "Center");
        return jPanel;
    }

    private Component createQuitButton() {
        JButton jButton = new JButton("Beenden");
        jButton.addActionListener(actionEvent -> this.quit());
        return jButton;
    }

    private void quit() {
        this.closeDialog();
    }

    @Override
    public void otherViewOpened() {
        this.closeDialog();
    }
}

