/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.website.update.ownlists.groupfile;

import de.duehl.basics.io.Charset;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.text.Text;
import de.duehl.vocabulary.japanese.website.update.ownlists.groupfile.data.GroupFileEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GroupFileIo {
    public static final String GROUP_BARE_FILENAME = "group.grp";
    private static final Charset GROUP_FILE_CHARSET = Charset.UTF_8;

    public static String createGroupFileContent(String string, Map<String, List<String>> map, Map<String, String> map2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : map.get(string)) {
            String string3 = map2.get(string2);
            String string4 = FileHelper.getBareName(string3);
            String string5 = string4 + "\t" + string2;
            arrayList.add(string5);
        }
        return Text.joinWithLineBreak(arrayList);
    }

    public static void writeGroupFile(String string, String string2) {
        FileHelper.writeTextToFile(string2, string, GROUP_FILE_CHARSET);
    }

    public static List<GroupFileEntry> readGroupFile(String string) {
        ArrayList<GroupFileEntry> arrayList = new ArrayList<GroupFileEntry>();
        List<String> list = FileHelper.readFileToList(string, GROUP_FILE_CHARSET);
        for (String string2 : list) {
            if (string2.isBlank()) continue;
            List<String> list2 = Text.splitByTabulator(string2);
            if (list2.size() != 2) {
                return new ArrayList<GroupFileEntry>();
            }
            String string3 = list2.get(0);
            String string4 = list2.get(1);
            arrayList.add(new GroupFileEntry(string3, string4));
        }
        return arrayList;
    }

    public static Map<String, String> createListNameByBareListFilenameMap(List<GroupFileEntry> list) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (GroupFileEntry groupFileEntry : list) {
            String string = groupFileEntry.getListBareFilename();
            String string2 = groupFileEntry.getListName();
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    public static Map<String, String> createBareListFilenameByListNameMap(List<GroupFileEntry> list) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (GroupFileEntry groupFileEntry : list) {
            String string = groupFileEntry.getListBareFilename();
            String string2 = groupFileEntry.getListName();
            hashMap.put(string2, string);
        }
        return hashMap;
    }
}

