/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.autodetect.ent.multiple;

import de.duehl.basics.autodetect.AutoDetectionHelper;
import de.duehl.basics.autodetect.ent.multiple.DetectMultipleThingsFinder;
import de.duehl.basics.autodetect.ent.multiple.MultipleEntityReplacer;
import de.duehl.basics.text.Text;
import de.duehl.basics.text.data.FoundSearch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MultipleEntityReplacerWithThingsFinder
extends MultipleEntityReplacer {
    private final DetectMultipleThingsFinder thingsFinder;
    private final int numberOfThingsDetectedBefore;

    public MultipleEntityReplacerWithThingsFinder(String string, String string2, DetectMultipleThingsFinder detectMultipleThingsFinder) {
        this(string, string2, detectMultipleThingsFinder, 0);
    }

    public MultipleEntityReplacerWithThingsFinder(String string, String string2, DetectMultipleThingsFinder detectMultipleThingsFinder, int n) {
        super(string, string2);
        this.thingsFinder = detectMultipleThingsFinder;
        this.numberOfThingsDetectedBefore = n;
    }

    @Override
    public void replace() {
        this.standardDetect();
    }

    protected final void standardDetect() {
        List<FoundSearch> list = this.thingsFinder.findAllThings(this.ent);
        Collections.reverse(list);
        this.replaceFoundSearchesInEnt(list);
        Collections.reverse(this.valueList);
    }

    private void replaceFoundSearchesInEnt(List<FoundSearch> list) {
        String string;
        ArrayList<FoundSearch> arrayList = new ArrayList<FoundSearch>();
        for (FoundSearch object : list) {
            int foundSearch = object.getEnd();
            string = this.ent.substring(foundSearch);
            if (Text.startsWithLowercaseLetter(string)) continue;
            arrayList.add(object);
        }
        int n = this.numberOfThingsDetectedBefore + arrayList.size();
        for (FoundSearch foundSearch : arrayList) {
            string = foundSearch.getSearch();
            int n2 = foundSearch.getIndex();
            int n3 = foundSearch.getEnd();
            String string2 = this.ent.substring(0, n2);
            String string3 = this.ent.substring(n3);
            this.valueList.add(string);
            String string4 = AutoDetectionHelper.createEntity(this.replacementFrontPart, n);
            --n;
            this.ent = string2 + string4 + string3;
            this.appendAutoComment("[" + this.replacementFrontPart + " detected]");
        }
    }
}

