/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.collections;

import de.duehl.basics.collections.ListApplier;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.text.NumberString;
import de.duehl.basics.text.Text;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class CollectionsHelper {
    private static final boolean DEBUG = false;
    private static final List<String> COMMA_POINT_ETC = CollectionsHelper.buildListFrom(",", ".", ":", ";");

    public static void printElements(List<?> list) {
        for (Object obj : list) {
            System.out.println(obj.toString());
        }
    }

    public static void printListNice(List<?> list) {
        System.out.print(CollectionsHelper.listListNice(list));
    }

    public static <T> void printListOfListNice(List<List<T>> list) {
        System.out.print(CollectionsHelper.listListOfListNice(list));
    }

    public static String listListNice(List<?> list) {
        return CollectionsHelper.listListNice(list, 1);
    }

    public static String listListNice(List<?> list, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            String string = String.format("    %2d. [%s]", i + n, list.get(i).toString());
            stringBuilder.append(string).append(Text.LINE_BREAK);
        }
        return stringBuilder.toString();
    }

    public static <T> String listListOfListNice(List<List<T>> list) {
        return CollectionsHelper.listListOfListNice(list, 1);
    }

    public static <T> String listListOfListNice(List<List<T>> list, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            int n2 = i + n;
            String string = String.format("    %2d. Liste:", n2);
            stringBuilder.append(string).append(Text.LINE_BREAK);
            List<T> list2 = list.get(i);
            for (int j = 0; j < list2.size(); ++j) {
                int n3 = j + 1;
                String string2 = String.format("        %4d.%d. [%s]", n2, n3, list2.get(j).toString());
                stringBuilder.append(string2).append(Text.LINE_BREAK);
            }
        }
        return stringBuilder.toString();
    }

    public static String listListNiceWithoutBrackets(List<?> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            String string = String.format("    %2d. %s", i + 1, list.get(i).toString());
            stringBuilder.append(string).append(Text.LINE_BREAK);
        }
        return stringBuilder.toString();
    }

    public static String listListIndentedWithoutNumberAndBracket(List<?> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            stringBuilder.append("    ").append(list.get(i).toString()).append(Text.LINE_BREAK);
        }
        return stringBuilder.toString();
    }

    public static String listListWithoutNumberAndBracket(List<?> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            stringBuilder.append(list.get(i).toString()).append(Text.LINE_BREAK);
        }
        return stringBuilder.toString();
    }

    public static String listList(List<?> list, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            if (i >= n) {
                object = "    ... [... weitere " + (list.size() - n) + " Elemente ...]";
                stringBuilder.append((String)object).append(Text.LINE_BREAK);
                break;
            }
            object = String.format("    %2d. [%s]", i + 1, list.get(i).toString());
            stringBuilder.append((String)object).append(Text.LINE_BREAK);
        }
        return stringBuilder.toString();
    }

    public static List<Integer> getSortedIndices(Set<Integer> set) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.addAll(set);
        Collections.sort(arrayList);
        return arrayList;
    }

    public static List<String> getSortedStringIndices(Set<String> set) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(set);
        Collections.sort(arrayList);
        return arrayList;
    }

    public static List<Integer> getSortedMapIndices(Map<Integer, ?> map) {
        Set<Integer> set = map.keySet();
        return CollectionsHelper.getSortedIndices(set);
    }

    public static List<String> getSortedMapStringIndices(Map<String, ?> map) {
        Set<String> set = map.keySet();
        return CollectionsHelper.getSortedStringIndices(set);
    }

    public static <T> List<T> reverseList(List<T> list) {
        ArrayList<T> arrayList = new ArrayList<T>();
        arrayList.addAll(list);
        Collections.reverse(arrayList);
        return arrayList;
    }

    @SafeVarargs
    public static <T> List<T> buildListFrom(T ... TArray) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t : TArray) {
            arrayList.add(t);
        }
        return arrayList;
    }

    @SafeVarargs
    public static <T> List<T> buildListFrom(List<T> list, T ... TArray) {
        ArrayList<T> arrayList = new ArrayList<T>();
        arrayList.addAll(list);
        arrayList.addAll(CollectionsHelper.buildListFrom(TArray));
        return arrayList;
    }

    public static List<String> buildLoweredListFrom(String ... stringArray) {
        return CollectionsHelper.buildLoweredListFrom(CollectionsHelper.arrayToList(stringArray));
    }

    public static List<String> buildLoweredListFrom(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            arrayList.add(Text.toLowerCase(string));
        }
        return arrayList;
    }

    public static List<String> buildUpperedListFrom(String ... stringArray) {
        return CollectionsHelper.buildUpperedListFrom(CollectionsHelper.arrayToList(stringArray));
    }

    public static List<String> buildUpperedListFrom(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            arrayList.add(Text.toUpperCase(string));
        }
        return arrayList;
    }

    public static List<String> buildSortByLengthDescandingListFrom(String ... stringArray) {
        List<String> list = CollectionsHelper.buildListFrom(stringArray);
        return CollectionsHelper.buildSortByLengthDescandingListFrom(list);
    }

    public static List<String> buildSortByLengthDescandingListFrom(List<String> list) {
        List<String> list2 = CollectionsHelper.copyList(list);
        Collections.sort(list2, new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return string2.length() - string.length();
            }
        });
        return list2;
    }

    public static List<String> buildSortByLengthListFrom(String ... stringArray) {
        List<String> list = CollectionsHelper.buildListFrom(stringArray);
        return CollectionsHelper.buildSortByLengthListFrom(list);
    }

    public static List<String> buildSortByLengthListFrom(List<String> list) {
        List<String> list2 = CollectionsHelper.copyList(list);
        Collections.sort(list2, new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return string.length() - string2.length();
            }
        });
        return list2;
    }

    public static List<String> buildSortedListFrom(String ... stringArray) {
        List<String> list = CollectionsHelper.buildListFrom(stringArray);
        Collections.sort(list);
        return list;
    }

    public static List<String> buildDescandingSortedListFrom(String ... stringArray) {
        List<String> list = CollectionsHelper.buildSortedListFrom(stringArray);
        Collections.reverse(list);
        return list;
    }

    public static void removeEmptyStringsFromList(List<String> list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            String string = list.get(i);
            if (!string.isEmpty()) continue;
            list.remove(i);
        }
    }

    public static void removeEmptyAndOnlyWhitespaceStringsFromList(List<String> list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            String string = list.get(i);
            if (!string.trim().isEmpty()) continue;
            list.remove(i);
        }
    }

    public static void removeCommentLinesFromList(List<String> list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            String string = list.get(i);
            if (!string.trim().startsWith("#")) continue;
            list.remove(i);
        }
    }

    public static List<String> removeMultipleValues(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static void removeLastListEntry(List<?> list) {
        if (!list.isEmpty()) {
            int n = list.size() - 1;
            list.remove(n);
        }
    }

    public static <T> T removeLastListEntryFromNotEmptyList(List<T> list) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Die \u00fcbergebene Liste ist leer!");
        }
        int n = list.size() - 1;
        return list.remove(n);
    }

    public static void removeFirstListEntry(List<?> list) {
        if (!list.isEmpty()) {
            int n = 0;
            list.remove(n);
        }
    }

    public static <T> T removeFirstListEntryFromNotEmptyList(List<T> list) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Die \u00fcbergebene Liste ist leer!");
        }
        int n = 0;
        return list.remove(n);
    }

    public static <T> List<T> arrayToList(T[] TArray) {
        return new ArrayList<T>(Arrays.asList(TArray));
    }

    public static List<Integer> arrayToList(int[] nArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int n : nArray) {
            arrayList.add(n);
        }
        return arrayList;
    }

    public static List<Double> arrayToList(double[] dArray) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (double d : dArray) {
            arrayList.add(d);
        }
        return arrayList;
    }

    public static List<String> stringArrayToList(String[] stringArray) {
        return new ArrayList<String>(Arrays.asList(stringArray));
    }

    public static String[] stringListToArray(List<String> list) {
        String[] stringArray = new String[list.size()];
        stringArray = list.toArray(stringArray);
        return stringArray;
    }

    public static String stringArrayToString(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        return Text.join(", ", arrayList);
    }

    public static <T> List<T> vectorToList(Vector<T> vector) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t : vector) {
            arrayList.add(t);
        }
        return arrayList;
    }

    public static void removeEmptyStringsAtFrontOfList(List<String> list) {
        int n = CollectionsHelper.determineIndexOfFirstNotEmptyElement(list);
        for (int i = list.size() - 1; i >= 0; --i) {
            if (i >= n) continue;
            list.remove(i);
        }
    }

    static int determineIndexOfFirstNotEmptyElement(List<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (string.isEmpty()) continue;
            return i;
        }
        return list.size();
    }

    public static void removeEmptyStringsAtEndOfList(List<String> list) {
        int n = CollectionsHelper.determineIndexOfLastNotEmptyElement(list);
        for (int i = list.size() - 1; i >= 0; --i) {
            if (i <= n) continue;
            list.remove(i);
        }
    }

    static int determineIndexOfLastNotEmptyElement(List<String> list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            String string = list.get(i);
            if (string.isEmpty()) continue;
            return i;
        }
        return -1;
    }

    public static void sortStringListByLengthDescanding(List<String> list) {
        Collections.sort(list, CollectionsHelper.createSortStringListByLengthDescandingComparator());
    }

    private static Comparator<String> createSortStringListByLengthDescandingComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                int n = string.length();
                int n2 = string2.length();
                int n3 = n2 - n;
                if (n3 != 0) {
                    return n3;
                }
                return string.compareTo(string2);
            }
        };
    }

    public static boolean isDisjunct(List<?> list) {
        for (int i = 0; i < list.size() - 1; ++i) {
            for (int j = i + 1; j < list.size(); ++j) {
                if (!list.get(i).equals(list.get(j))) continue;
                return false;
            }
        }
        return true;
    }

    public static List<String> getNotDisjunktTexts(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size() - 1; ++i) {
            for (int j = i + 1; j < list.size(); ++j) {
                String string;
                String string2 = list.get(i);
                if (!string2.equals(string = list.get(j)) || arrayList.contains(string2)) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    public static List<String> createDisjunctLowerCaseList(List<String> list) {
        return CollectionsHelper.createDisjunctList(CollectionsHelper.toLowerCase(list));
    }

    public static <Element> List<Element> createDisjunctList(List<Element> list) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (Element Element : list) {
            if (arrayList.contains(Element)) continue;
            arrayList.add(Element);
        }
        return arrayList;
    }

    public static <Element> void makeListDisjunct(List<Element> list) {
        block0: for (int i = list.size() - 1; i > 0; --i) {
            Element Element = list.get(i);
            for (int j = 0; j < i; ++j) {
                Element Element2 = list.get(j);
                if (!Element.equals(Element2)) continue;
                list.remove(i);
                continue block0;
            }
        }
    }

    public static List<String> toLowerCase(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            arrayList.add(Text.toLowerCase(string));
        }
        return arrayList;
    }

    public static List<String> toUpperCase(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            arrayList.add(Text.toUpperCase(string));
        }
        return arrayList;
    }

    public static List<String> surroundElements(List<String> list, String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string3 : list) {
            String string4 = string + string3 + string2;
            arrayList.add(string4);
        }
        return arrayList;
    }

    public static List<String> keepOnlyFirstLines(List<String> list, int n) {
        if (list.size() <= n) {
            return list;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(list.get(i));
        }
        return arrayList;
    }

    public static String[] appendInfrontOfArray(String string, String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = string;
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i + 1] = stringArray[i];
        }
        return stringArray2;
    }

    public static String[] appendAtEndOfArray(String[] stringArray, String string) {
        String[] stringArray2 = new String[stringArray.length + 1];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i];
        }
        stringArray2[stringArray.length] = string;
        return stringArray2;
    }

    public static List<String> getSection(List<String> list, String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        for (String string3 : list) {
            if (bl) {
                if (string3.contains(string2)) {
                    return arrayList;
                }
                arrayList.add(string3);
                continue;
            }
            if (!string3.contains(string)) continue;
            bl = true;
        }
        if (!bl) {
            throw new RuntimeException("Der Startbegriff '" + string + "' wurde nicht in der Liste gefunden.");
        }
        throw new RuntimeException("Der Endbegriff '" + string2 + "' wurde nach dem Startbegriff nicht in der Liste gefunden.");
    }

    public static List<String> removeSectionExcludingStartAndEnd(List<String> list, String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        boolean bl2 = false;
        for (String string3 : list) {
            if (bl && !bl2) {
                if (!string3.contains(string2)) continue;
                bl2 = true;
                arrayList.add(string3);
                continue;
            }
            if (bl2) {
                arrayList.add(string3);
                continue;
            }
            if (string3.contains(string)) {
                bl = true;
            }
            arrayList.add(string3);
        }
        if (!bl) {
            throw new RuntimeException("Der Startbegriff '" + string + "' wurde nicht in der Liste gefunden.");
        }
        if (!bl2) {
            throw new RuntimeException("Der Endbegriff '" + string2 + "' wurde nach dem Startbegriff nicht in der Liste gefunden.");
        }
        return arrayList;
    }

    public static List<String> removeSectionIncludingStartAndEnd(List<String> list, String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        boolean bl2 = false;
        for (String string3 : list) {
            if (bl && !bl2) {
                if (!string3.contains(string2)) continue;
                bl2 = true;
                continue;
            }
            if (!bl2 && string3.contains(string)) {
                bl = true;
                continue;
            }
            arrayList.add(string3);
        }
        if (!bl) {
            throw new RuntimeException("Der Startbegriff '" + string + "' wurde nicht in der Liste gefunden.");
        }
        if (!bl2) {
            throw new RuntimeException("Der Endbegriff '" + string2 + "' wurde nach dem Startbegriff nicht in der Liste gefunden.");
        }
        return arrayList;
    }

    public static boolean anyLineContains(List<String> list, String string) {
        for (String string2 : list) {
            if (!string2.contains(string)) continue;
            return true;
        }
        return false;
    }

    public static <T> List<Integer> findAllIndces(T t, List<T> list) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < list.size(); ++i) {
            T t2 = list.get(i);
            if (!t2.equals(t)) continue;
            arrayList.add(i);
        }
        return arrayList;
    }

    public static List<String> joinStringLists(List<String> list, List<String> list2) {
        return CollectionsHelper.joinLists(list, list2);
    }

    @SafeVarargs
    public static <T> List<T> joinLists(List<T> ... listArray) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (List<T> list : listArray) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    @SafeVarargs
    public static <T> List<T> joinListsDisjunct(List<T> ... listArray) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (List<T> list : listArray) {
            for (T t : list) {
                if (arrayList.contains(t)) continue;
                arrayList.add(t);
            }
        }
        return arrayList;
    }

    public static <Element> List<Element> copyList(List<Element> list) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        arrayList.addAll(list);
        return arrayList;
    }

    public static List<String> trimList(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            arrayList.add(string.trim());
        }
        return arrayList;
    }

    public static List<String> trimAndCompactSpaces(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            arrayList.add(Text.trimAndCompactSpaces(string));
        }
        return arrayList;
    }

    public static <T> boolean listStartsWith(List<T> list, List<T> list2) {
        if (list.size() < list2.size()) {
            return false;
        }
        for (int i = 0; i < list2.size(); ++i) {
            T t;
            T t2 = list.get(i);
            if (t2.equals(t = list2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean inputEqualsAnyListElement(String string, List<String> list) {
        for (String string2 : list) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean inputStartsWithAnyListElement(String string, List<String> list) {
        for (String string2 : list) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean inputEndsWithAnyListElement(String string, List<String> list) {
        for (String string2 : list) {
            if (!string.endsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public static String getElementOnWichTheInputEnds(String string, List<String> list) {
        for (String string2 : list) {
            if (!string.endsWith(string2)) continue;
            return string2;
        }
        return "";
    }

    public static List<String> splitStringIntoLetters(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < string.length(); ++i) {
            String string2 = string.substring(i, i + 1);
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static List<String> replace(List<String> list, String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string3 : list) {
            String string4 = string3.replace(string, string2);
            arrayList.add(string4);
        }
        return arrayList;
    }

    public static List<String> replaceAll(List<String> list, String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string3 : list) {
            String string4 = string3.replaceAll(string, string2);
            arrayList.add(string4);
        }
        return arrayList;
    }

    public static <T> List<String> applyToList(List<T> list, ListApplier<T> listApplier) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (T t : list) {
            String string = listApplier.apply(t);
            arrayList.add(string);
        }
        return arrayList;
    }

    public static void sortAscanding(List<Integer> list) {
        Collections.sort(list, new Comparator<Integer>(){

            @Override
            public int compare(Integer n, Integer n2) {
                return n - n2;
            }
        });
    }

    public static void sortDescanding(List<Integer> list) {
        Collections.sort(list, new Comparator<Integer>(){

            @Override
            public int compare(Integer n, Integer n2) {
                return n2 - n;
            }
        });
    }

    public static void removeElementsFromListByIndices(List<?> list, List<Integer> list2) {
        List<Integer> list3 = CollectionsHelper.createDisjunctList(list2);
        CollectionsHelper.sortDescanding(list3);
        for (int n : list3) {
            list.remove(n);
        }
    }

    public static <T> String createListDifference(List<T> list, String string, List<T> list2, String string2) {
        T t;
        int n;
        int n2;
        StringBuilder stringBuilder = new StringBuilder().append("Vergleich der Listen '" + string + "' (1) und '" + string2 + "' (2):").append(Text.LINE_BREAK);
        int n3 = list.size();
        if (n3 == (n2 = list2.size())) {
            stringBuilder.append("Beide Listen haben " + NumberString.taupu(n3) + " Elemente.").append(Text.LINE_BREAK);
        } else {
            stringBuilder.append("Die Listen haben eine unterschiedliche Anzahl an Elementen!").append(Text.LINE_BREAK).append("    Liste 1 hat " + NumberString.taupu(n3) + " Elemente.").append(Text.LINE_BREAK).append("    Liste 2 hat " + NumberString.taupu(n2) + " Elemente.").append(Text.LINE_BREAK);
        }
        int n4 = 0;
        int n5 = Math.min(n3, n2);
        for (n = 0; n < n5; ++n) {
            T t2;
            t = list.get(n);
            if (t.equals(t2 = list2.get(n))) continue;
            ++n4;
            stringBuilder.append("Element Nummer " + (n + 1) + " (also am Index " + n + ") ist verschieden:").append(Text.LINE_BREAK).append("    Liste 1 hat dort das Element '" + t + "'.").append(Text.LINE_BREAK).append("    Liste 2 hat dort das Element '" + t2 + "'.").append(Text.LINE_BREAK);
        }
        if (n3 > n2) {
            stringBuilder.append("Weitere Elemente in Liste 1:").append(Text.LINE_BREAK);
            for (n = n5; n < n3; ++n) {
                t = list.get(n);
                stringBuilder.append("    " + (n + 1) + " : " + t).append(Text.LINE_BREAK);
            }
        } else if (n2 > n3) {
            stringBuilder.append("Weitere Elemente in Liste 2:").append(Text.LINE_BREAK);
            for (n = n5; n < n2; ++n) {
                t = list2.get(n);
                stringBuilder.append("    " + (n + 1) + " : " + t).append(Text.LINE_BREAK);
            }
        }
        if (0 == n4) {
            stringBuilder.append("Die Elemente an gemeinsamen Indices sind in beiden Listen identisch.").append(Text.LINE_BREAK);
        } else {
            stringBuilder.append("Die beiden Listen haben " + NumberString.taupu(n4) + " unterschiedliche(s) Element(e) an an gemeinsamen Indices.").append(Text.LINE_BREAK);
        }
        return stringBuilder.toString();
    }

    public static boolean containsIgnoreCase(List<String> list, String string) {
        for (String string2 : list) {
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    public static List<String> mixIntoList(List<String> list, List<String> list2, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = list2.size();
        int n3 = list.size() + n2;
        for (int i = 0; i < n3; ++i) {
            String string;
            if (i < n) {
                string = list.get(i);
                arrayList.add(string);
                continue;
            }
            if (i >= n && i < n + n2) {
                string = list2.get(i - n);
                arrayList.add(string);
                continue;
            }
            string = list.get(i - n2);
            arrayList.add(string);
        }
        return arrayList;
    }

    public static List<String> createEmptyStringList(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            arrayList.add("");
        }
        return arrayList;
    }

    public static <K extends Comparable<K>, V> K getFirstMapKeyByValue(Map<K, V> map, V v, K k) {
        Object object = k;
        boolean bl = false;
        for (Comparable comparable : map.keySet()) {
            V v2 = map.get(comparable);
            if (!v2.equals(v)) continue;
            if (bl) {
                if (comparable.compareTo(object) >= 0) continue;
                object = comparable;
                continue;
            }
            object = comparable;
            bl = true;
        }
        return object;
    }

    public static <T> int getLastListIndex(List<T> list) {
        if (list.isEmpty()) {
            return -1;
        }
        return list.size() - 1;
    }

    public static <T> T getLastListMember(List<T> list) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Die \u00fcbergebene Liste ist leer.");
        }
        return list.get(CollectionsHelper.getLastListIndex(list));
    }

    public static <T> T getLastListMember(List<T> list, T t) {
        if (list.isEmpty()) {
            return t;
        }
        return CollectionsHelper.getLastListMember(list);
    }

    public static <Element> boolean containedMoreThanOnce(List<Element> list, Element Element) {
        return CollectionsHelper.containedMinNTines(list, Element, 2);
    }

    public static <Element> boolean containedMinNTines(List<Element> list, Element Element, int n) {
        int n2 = 0;
        for (Element Element2 : list) {
            if (!Element2.equals(Element) || ++n2 < n) continue;
            return true;
        }
        return false;
    }

    public static <Element> int countElementInList(List<Element> list, Element Element) {
        int n = 0;
        for (Element Element2 : list) {
            if (!Element2.equals(Element)) continue;
            ++n;
        }
        return n;
    }

    public static void printAssertEquals(List<String> list) {
        CollectionsHelper.printAssertEquals(list, "list");
    }

    public static void printAssertEquals(List<String> list, String string) {
        System.out.println("        assertEquals(" + list.size() + ", " + string + ".size());");
        for (int i = 0; i < list.size(); ++i) {
            System.out.println("        assertEquals(\"" + list.get(i).replace("\"", "\\\"") + "\", " + string + ".get(" + Text.fillWithSpacesAtFront(Integer.toString(i), 2) + "));");
        }
    }

    public static String toEnumeration(List<String> list, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!list.isEmpty()) {
            if (list.size() == 1) {
                stringBuilder.append("'").append(list.get(0)).append("'");
            } else {
                for (int i = 0; i < list.size() - 2; ++i) {
                    stringBuilder.append("'").append(list.get(i)).append("', ");
                }
                stringBuilder.append("'").append(list.get(list.size() - 2)).append("' ");
                stringBuilder.append(string);
                stringBuilder.append(" '").append(list.get(list.size() - 1)).append("'");
            }
        }
        return stringBuilder.toString();
    }

    public static <Element> List<Element> sublist(List<Element> list, int n) {
        return CollectionsHelper.sublist(list, n, list.size());
    }

    public static <Element> List<Element> sublist(List<Element> list, int n, int n2) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (int i = n; i < n2; ++i) {
            arrayList.add(list.get(i));
        }
        return arrayList;
    }

    public static <Element> List<Element> sublistWithoutFirstAndLastLine(List<Element> list) {
        if (list.isEmpty()) {
            throw new RuntimeException("Es wurde eine leere Liste \u00fcbergeben.");
        }
        return CollectionsHelper.sublist(list, 1, list.size() - 1);
    }

    public static int determineIndexOfFirstElementContaining(List<String> list, String string) {
        return CollectionsHelper.determineIndexOfFirstElementContaining(list, string, 0);
    }

    public static int determineIndexOfFirstElementContaining(List<String> list, String string, int n) {
        for (int i = n; i < list.size(); ++i) {
            String string2 = list.get(i);
            if (!string2.contains(string)) continue;
            return i;
        }
        return -1;
    }

    public static List<String> addSpaceToAllListMembers(List<String> list) {
        return CollectionsHelper.addToAllListMembers(list, " ");
    }

    public static List<String> addToAllListMembers(List<String> list, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : list) {
            String string3 = string2 + string;
            arrayList.add(string3);
        }
        return arrayList;
    }

    public static List<String> addBeforeAllListMembers(List<String> list, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : list) {
            String string3 = string + string2;
            arrayList.add(string3);
        }
        return arrayList;
    }

    public static List<String> addAllBeforeAllListMembers(List<String> list, List<String> list2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list2) {
            arrayList.addAll(CollectionsHelper.addBeforeAllListMembers(list, string));
        }
        return arrayList;
    }

    public static boolean containedInAnyListElement(String string, List<String> list) {
        for (String string2 : list) {
            if (!string2.contains(string)) continue;
            return true;
        }
        return false;
    }

    public static void sortNumberStringsAsInteger(List<String> list) {
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                int n = NumberString.parseInt(string);
                int n2 = NumberString.parseInt(string2);
                return n - n2;
            }
        });
    }

    public static void addEmptyLines(List<String> list) {
        for (int i = list.size() - 1; i > 0; --i) {
            list.add(i, "");
        }
    }

    @Deprecated
    public static List<String> createFlatListFromDictionary(List<List<String>> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (List<String> list2 : list) {
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    public static void removeColonAtEnd(List<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (!string.endsWith(":")) continue;
            string = string.substring(0, string.length() - 1);
            string = string.trim();
            list.set(i, string);
        }
    }

    public static List<String> withAndWithoutColon(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            arrayList.addAll(CollectionsHelper.withAndWithoutColon(string));
        }
        return arrayList;
    }

    private static List<String> withAndWithoutColon(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string + ":");
        arrayList.add(string);
        return arrayList;
    }

    public static List<String> withAndWithoutComma(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            arrayList.addAll(CollectionsHelper.withAndWithoutComma(string));
        }
        return arrayList;
    }

    private static List<String> withAndWithoutComma(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("; " + string);
        arrayList.add(", " + string);
        arrayList.add(string);
        return arrayList;
    }

    public static List<List<String>> listOfLinesToListOfFieldLines(List<String> list) {
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        for (String string : list) {
            List<String> list2 = Text.splitByTabulator(string);
            arrayList.add(list2);
        }
        return arrayList;
    }

    public static List<String> listOfFieldLinesToListOfLines(List<List<String>> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (List<String> list2 : list) {
            String string = Text.joinWithTabulator(list2);
            arrayList.add(string);
        }
        return arrayList;
    }

    public static List<String> changeOnlySpacesToEmptyString(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            String string2 = string.isBlank() ? "" : string;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static void switchPipesToSlashes(List<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            string = string.replace("|", "/");
            list.set(i, string);
        }
    }

    public static void replaceMultipleLines(List<String> list, List<String> list2, List<String> list3) {
        int n = 0;
        int n2 = 0;
        while (n < list.size()) {
            int n3;
            String string = list.get(n);
            String string2 = list2.get(n2);
            ++n;
            if (!string.equals(string2) || ++n2 != list2.size()) continue;
            int n4 = n - n2;
            for (n3 = 0; n3 < list2.size(); ++n3) {
                list.remove(n4);
            }
            for (n3 = list3.size() - 1; n3 >= 0; --n3) {
                String string3 = list3.get(n3);
                list.add(n4, string3);
            }
            n = n4 + list3.size();
            n2 = 0;
        }
    }

    public static void removeCommaAtEnd(List<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            string = Text.removeTextAtEndIfEndsWith(string, ",");
            list.set(i, string);
        }
    }

    public static int determineFirstIndexStartingWith(List<String> list, String string) {
        return CollectionsHelper.determineFirstIndexStartingWith(list, string, 0);
    }

    public static int determineFirstIndexStartingWith(List<String> list, String string, int n) {
        for (int i = n; i < list.size(); ++i) {
            String string2 = list.get(i);
            if (!string2.startsWith(string)) continue;
            return i;
        }
        return -1;
    }

    public static List<Integer> determineAllIndicesStartingWith(List<String> list, String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < list.size(); ++i) {
            String string2 = list.get(i);
            if (!string2.startsWith(string)) continue;
            arrayList.add(i);
        }
        return arrayList;
    }

    public static List<String> createSortedKeysForStringIntegerMapByNumberDescanding(final Map<String, Integer> map) {
        ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
        Collections.sort(arrayList, new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                int n;
                int n2 = (Integer)map.get(string);
                if (n2 != (n = ((Integer)map.get(string2)).intValue())) {
                    return n - n2;
                }
                return string.compareTo(string2);
            }
        });
        return arrayList;
    }

    public static List<String> appendCommaPointEtc(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            for (String string2 : COMMA_POINT_ETC) {
                arrayList.add(string + string2);
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    public static <T> void switchListElements(List<T> list, int n, int n2) {
        T t = list.get(n);
        T t2 = list.get(n2);
        list.set(n, t2);
        list.set(n2, t);
    }

    public static String listMapNice(Map<String, List<Integer>> map, List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (String string : list) {
            if (!map.containsKey(string)) {
                throw new RuntimeException("Das Verzeichnis enth\u00e4lt nicht den gew\u00fcnschten Schl\u00fcssel '" + string + "'.\n");
            }
            String string2 = String.format("    %2d. %s -> %s", ++n, string, map.get(string).toString());
            stringBuilder.append(string2).append(Text.LINE_BREAK);
        }
        return stringBuilder.toString();
    }

    public static List<String> toBareFilenames(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            String string2 = FileHelper.getBareName(string);
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static List<String> createCartesianProduct(List<String> list, String string, List<String> list2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : list) {
            for (String string3 : list2) {
                String string4 = string2 + string + string3;
                arrayList.add(string4);
            }
        }
        return arrayList;
    }

    public static <T> void checkSizes(List<T> list, List<T> list2) {
        int n;
        int n2 = list.size();
        if (n2 != (n = list2.size())) {
            throw new RuntimeException("Die beiden \u00fcbergebenen Listen sind nicht gleich gro\u00df.\nElemente aus der ersten Liste:\n" + CollectionsHelper.listListIndentedWithoutNumberAndBracket(list) + "Elemente aus der zweiten Liste:\n" + CollectionsHelper.listListIndentedWithoutNumberAndBracket(list2));
        }
    }

    public static <T> void checkAllElementsOfFirstAreInSecond(List<T> list, List<T> list2) {
        for (T t : list) {
            if (list2.contains(t)) continue;
            throw new RuntimeException("Ein Element aus der ersten Liste ist nicht in derzweiten Liste enthalten.\n\tnicht enthaltendes Element:\n" + t + "\nElemente aus der ersten Liste:\n" + CollectionsHelper.listListIndentedWithoutNumberAndBracket(list) + "Elemente aus der zweiten Liste:\n" + CollectionsHelper.listListIndentedWithoutNumberAndBracket(list2));
        }
    }

    public static <T> boolean areAllElementsOfFirstAreInSecond(List<T> list, List<T> list2) {
        for (T t : list) {
            if (list2.contains(t)) continue;
            return false;
        }
        return true;
    }

    public static void addToMapWithQuantities(Map<String, Integer> map, String string) {
        CollectionsHelper.addToMapWithQuantities(map, string, 1);
    }

    public static void addToMapWithQuantities(Map<String, Integer> map, String string, int n) {
        if (!map.containsKey(string)) {
            map.put(string, 0);
        }
        int n2 = map.get(string);
        map.put(string, n2 += n);
    }

    public static void removeEntriesStartingWith(List<String> list, String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < list.size(); ++i) {
            String string2 = list.get(i);
            if (!string2.startsWith(string)) continue;
            arrayList.add(i);
        }
        Collections.reverse(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            list.remove(n);
        }
    }

    public static List<String> createStringListFromIntegerList(List<Integer> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int n : list) {
            String string = NumberString.taupu(n);
            arrayList.add(string);
        }
        return arrayList;
    }

    public static <T> void removeFirstAndLastElement(List<T> list) {
        if (list.size() < 3) {
            list.clear();
        } else {
            list.remove(0);
            int n = list.size() - 1;
            list.remove(n);
        }
    }

    public static <T> void removeFirstElement(List<T> list) {
        if (list.size() < 2) {
            list.clear();
        } else {
            list.remove(0);
        }
    }

    public static <T> void removeLastElement(List<T> list) {
        if (list.size() < 2) {
            list.clear();
        } else {
            int n = list.size() - 1;
            list.remove(n);
        }
    }

    public static int countLinesStartingWith(List<String> list, String string) {
        int n = 0;
        for (String string2 : list) {
            if (!string2.startsWith(string)) continue;
            ++n;
        }
        return n;
    }

    public static boolean areAllElementsBlank(List<String> list) {
        for (String string : list) {
            if (string.isBlank()) continue;
            return false;
        }
        return true;
    }

    public static void sortBetterAlphabethical(List<String> list) {
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return Text.compareStringsBetter(string, string2);
            }
        });
    }

    public static boolean isSortedIntegerList(List<Integer> list) {
        if (list.size() < 2) {
            return true;
        }
        int n = Integer.MIN_VALUE;
        for (int n2 : list) {
            if (n2 <= n) {
                return false;
            }
            n = n2;
        }
        return true;
    }

    public static void removeIntegerListsThatAreContainedInOtherListsFromListWithListsOfIntegers(List<List<Integer>> list) {
        CollectionsHelper.makeListDisjunct(list);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < list.size() - 1; ++i) {
            List<Integer> list2 = list.get(i);
            for (int j = 0; j < list.size(); ++j) {
                List<Integer> list3 = list.get(j);
                if (CollectionsHelper.areAllElementsOfFirstAreInSecond(list2, list3)) {
                    if (list2.size() >= list3.size() || arrayList.contains(i)) continue;
                    CollectionsHelper.say("Entferne " + list2 + " wegen " + list3 + " (1)");
                    arrayList.add(i);
                    continue;
                }
                if (!CollectionsHelper.areAllElementsOfFirstAreInSecond(list3, list2) || list3.size() >= list2.size() || arrayList.contains(j)) continue;
                CollectionsHelper.say("Entferne " + list3 + " wegen " + list2 + " (2)");
                arrayList.add(j);
            }
        }
        CollectionsHelper.sortDescanding(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            list.remove(n);
        }
    }

    public static void sortListOfIntegerListByFirstElementOfEachListAndLength(List<List<Integer>> list) {
        Collections.sort(list, new Comparator<List<Integer>>(){

            @Override
            public int compare(List<Integer> list, List<Integer> list2) {
                int n;
                int n2;
                int n3 = list.get(0);
                if (n3 < (n2 = list2.get(0).intValue())) {
                    return -1;
                }
                if (n3 > n2) {
                    return 1;
                }
                int n4 = list.size();
                if (n4 < (n = list2.size())) {
                    return -1;
                }
                if (n4 > n) {
                    return 1;
                }
                return 0;
            }
        });
    }

    public static <T> List<T> createShortList(List<T> list, int n) {
        ArrayList<T> arrayList = new ArrayList<T>();
        int n2 = 0;
        for (T t : list) {
            if (++n2 > n) break;
            arrayList.add(t);
        }
        return arrayList;
    }

    public static boolean startsAnyListElementWith(List<String> list, String string) {
        for (String string2 : list) {
            if (!string2.startsWith(string)) continue;
            return true;
        }
        return false;
    }

    public static void pruneEmptyListElementsAtEnd(List<String> list) {
        boolean bl = true;
        while (bl) {
            if (list.isEmpty()) {
                bl = false;
                continue;
            }
            int n = list.size() - 1;
            String string = list.get(n);
            if (string.isEmpty()) {
                list.remove(n);
                bl = true;
                continue;
            }
            bl = false;
        }
    }

    public static boolean allListElementsAreEqual(List<String> list) {
        if (list.isEmpty()) {
            return false;
        }
        String string = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            String string2 = list.get(i);
            if (string2.equals(string)) continue;
            return false;
        }
        return true;
    }

    public static int getSmallestValue(List<Integer> list, int n) {
        if (list.isEmpty()) {
            return n;
        }
        int n2 = Integer.MAX_VALUE;
        for (int n3 : list) {
            if (n2 <= n3) continue;
            n2 = n3;
        }
        return n2;
    }

    public static List<String> toStringList(List<Integer> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int n : list) {
            String string = Integer.toString(n);
            arrayList.add(string);
        }
        return arrayList;
    }

    private static void say(String string) {
    }
}

