/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.datetime.date;

import java.util.ArrayList;
import java.util.List;

public enum Weekday {
    UNKNOWN("Wochentag nicht gew\u00e4hlt", -1),
    MONDAY("Montag", 0),
    TUESDAY("Dienstag", 1),
    WEDNESDAY("Mittwoch", 2),
    THURSDAY("Donnerstag", 3),
    FRIDAY("Freitag", 4),
    SATURDAY("Samstag", 5),
    SUNDAY("Sonntag", 6);

    private final String germanName;
    private final int dayCode;

    private Weekday(String string2, int n2) {
        this.germanName = string2;
        this.dayCode = n2;
    }

    public String getGermanName() {
        return this.germanName;
    }

    public int getDayCode() {
        return this.dayCode;
    }

    public static Weekday getWeekdayByDayCodeStartingSunday(int n) {
        if (n < 0 || n > 6) {
            throw new IllegalArgumentException("Fehlerhafter dayCode = " + n);
        }
        int n2 = Weekday.calculateDayCodeFromSundayCode(n);
        return Weekday.getWeekdayByDayCode(n2);
    }

    private static int calculateDayCodeFromSundayCode(int n) {
        int n2 = n == 0 ? 6 : n - 1;
        return n2;
    }

    public static Weekday getWeekdayByDayCode(int n) {
        if (n < 0 || n > 6) {
            throw new IllegalArgumentException("Fehlerhafter dayCode = " + n);
        }
        for (Weekday weekday : Weekday.values()) {
            int n2 = weekday.getDayCode();
            if (n2 != n) continue;
            return weekday;
        }
        throw new RuntimeException("Darf nicht passieren! dayCode = " + n);
    }

    public static Weekday determineByGermanName(String string) {
        for (Weekday weekday : Weekday.values()) {
            if (!string.equals(weekday.getGermanName())) continue;
            return weekday;
        }
        if ("Sonnabend".equals(string)) {
            return SATURDAY;
        }
        return UNKNOWN;
    }

    public static List<Weekday> createDayListStartingMonday() {
        ArrayList<Weekday> arrayList = new ArrayList<Weekday>();
        arrayList.add(MONDAY);
        arrayList.add(TUESDAY);
        arrayList.add(WEDNESDAY);
        arrayList.add(THURSDAY);
        arrayList.add(FRIDAY);
        arrayList.add(SATURDAY);
        arrayList.add(SUNDAY);
        return arrayList;
    }

    public static List<String> createGermanNamesListStartingMonday() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Weekday weekday : Weekday.createDayListStartingMonday()) {
            arrayList.add(weekday.getGermanName());
        }
        return arrayList;
    }
}

