/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.io.textfile;

import de.duehl.basics.datetime.time.ContinousTimeMeasurement;
import de.duehl.basics.io.Charset;
import de.duehl.basics.io.Reader;
import de.duehl.basics.io.textfile.NotEmptyLineAnalyzer;
import de.duehl.basics.text.NumberString;

public abstract class FullTextFileReader {
    private static final int NUMBER_OF_LINES_READ_TO_PRINT_PROGRESS = 100000;
    protected final String filename;
    protected final Charset charset;
    private String lineDescription;
    private int countAnalysedLines;
    private String progressTextStart;
    private boolean skipBlankLines;
    private boolean verboose;
    private boolean skipFirstLine;
    private String skippedFirstLine;
    private int numberOfLinesReadToPrintProgress;
    private Reader reader;
    private boolean stopReading;
    private boolean showDiffenceBetweenTimeMeasurements;
    private ContinousTimeMeasurement timeMeasurement;

    public FullTextFileReader(String string, Charset charset) {
        this.filename = string;
        this.charset = charset;
        this.progressTextStart = "Einlesen";
        this.lineDescription = "";
        this.skipBlankLines = false;
        this.verboose = true;
        this.skipFirstLine = false;
        this.skippedFirstLine = "";
        this.numberOfLinesReadToPrintProgress = 100000;
        this.stopReading = false;
        this.showDiffenceBetweenTimeMeasurements = true;
        this.timeMeasurement = new ContinousTimeMeasurement();
    }

    public void setLineDescription(String string) {
        this.lineDescription = string;
    }

    public void setProgressTextStart(String string) {
        this.progressTextStart = string;
    }

    public void skipFirstLine() {
        this.skipFirstLine = true;
    }

    public void doNotSkipBlankLines() {
        this.skipBlankLines = false;
    }

    public void skipBlankLines() {
        this.skipBlankLines = true;
    }

    public void beQuiet() {
        this.verboose = false;
    }

    public void setNumberOfLinesReadToPrintProgress(int n) {
        this.numberOfLinesReadToPrintProgress = n;
    }

    public void stopReading() {
        this.stopReading = true;
    }

    public void hideDiffenceBetweenTimeMeasurements() {
        this.showDiffenceBetweenTimeMeasurements = false;
    }

    public void read(NotEmptyLineAnalyzer notEmptyLineAnalyzer) {
        String string;
        this.timeMeasurement = new ContinousTimeMeasurement();
        this.timeMeasurement.startTimeMeasuring();
        this.reader = this.openReader();
        if (this.skipFirstLine) {
            this.skippedFirstLine = this.reader.readNextLine();
        }
        this.countAnalysedLines = 0;
        while ((string = this.reader.readNextLine()) != null && !this.stopReading) {
            if (this.skipBlankLines && string.trim().isEmpty()) continue;
            notEmptyLineAnalyzer.analyseLine(string);
            ++this.countAnalysedLines;
            if (this.countAnalysedLines % this.numberOfLinesReadToPrintProgress != 0) continue;
            this.printProgressOutputInLoop();
        }
        this.printProgressOutputAfterLoop();
        this.reader.close();
        this.timeMeasurement.stopTimeMeasuring();
    }

    protected abstract Reader openReader();

    private void printProgressOutputInLoop() {
        this.printProgressOutput("bislang");
    }

    private void printProgressOutputAfterLoop() {
        this.printProgressOutput("insgesamt");
    }

    private void printProgressOutput(String string) {
        if (this.verboose) {
            this.reallyPrintProgressOutput(string);
        }
    }

    private void reallyPrintProgressOutput(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.progressTextStart).append(" von ").append(NumberString.taupu(this.countAnalysedLines));
        if (!this.lineDescription.isEmpty()) {
            stringBuilder.append(" mit ").append(this.lineDescription);
        }
        stringBuilder.append(" in ").append(string).append(": ");
        if (this.showDiffenceBetweenTimeMeasurements) {
            stringBuilder.append(this.timeMeasurement.timeMeasurement());
        } else {
            stringBuilder.append(this.getRuntime());
        }
        System.out.println(stringBuilder.toString());
    }

    public int getLineNumber() {
        return this.reader.getLineNumber();
    }

    public String getRuntime() {
        return this.timeMeasurement.getRuntime();
    }

    public String getSkippedFirstLine() {
        return this.skippedFirstLine;
    }

    public String getFilename() {
        return this.filename;
    }
}

