/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.io.textfile.columns;

import de.duehl.basics.io.Charset;
import de.duehl.basics.io.FineFileReader;
import de.duehl.basics.io.FineFileWriter;
import de.duehl.basics.io.Writer;
import de.duehl.basics.text.Text;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ColumnsCutter {
    private final String inputFilename;
    private final String outputFilename;
    private final List<Integer> columnNumbersToKeep;
    private Charset charset;
    private int numberOfColumnsInFirstLine;
    private Writer writer;
    private int lineNumber;
    private final int highestColumnNumberToKeep;

    public ColumnsCutter(String string, String string2, int n) {
        this(string, string2, ColumnsCutter.createNumberList(1, n));
    }

    public ColumnsCutter(String string, String string2, int n, int n2) {
        this(string, string2, ColumnsCutter.createNumberList(n, n2));
    }

    private static List<Integer> createNumberList(int n, int n2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (n > n2) {
            throw new RuntimeException("Die Nummer der ersten zu behaltenden Spalte ist gr\u00f6\u00dfer als die Nummer der letzten zu behaltenden Spalte.\n\tfirstColumnNumberToKeep = " + n + "\n\tlastColumnNumberToKeep = " + n2 + "\n");
        }
        for (int i = n; i <= n2; ++i) {
            arrayList.add(i);
        }
        return arrayList;
    }

    public ColumnsCutter(String string, String string2, List<Integer> list) {
        this.inputFilename = string;
        this.outputFilename = string2;
        this.columnNumbersToKeep = list;
        Collections.sort(list);
        this.charset = Charset.ISO_8859_1;
        this.highestColumnNumberToKeep = this.determineHighestColumnNumberToKeep();
    }

    private int determineHighestColumnNumberToKeep() {
        int n = -1;
        for (int n2 : this.columnNumbersToKeep) {
            if (n >= n2) continue;
            n = n2;
        }
        return n;
    }

    public void useUtf8() {
        this.charset = Charset.UTF_8;
    }

    public void cut() {
        FineFileReader fineFileReader = new FineFileReader(this.inputFilename, this.charset);
        this.writer = new FineFileWriter(this.outputFilename, this.charset);
        String string = fineFileReader.readNextLine();
        this.lineNumber = fineFileReader.getLineNumber();
        this.numberOfColumnsInFirstLine = this.analyseColumnSizeOfFirstLine(string);
        this.workWithLine(string);
        String string2 = fineFileReader.readNextLine();
        while (string2 != null) {
            this.lineNumber = fineFileReader.getLineNumber();
            this.workWithLine(string2);
            string2 = fineFileReader.readNextLine();
        }
        this.writer.close();
        fineFileReader.close();
    }

    private int analyseColumnSizeOfFirstLine(String string) {
        if (null == string) {
            return 0;
        }
        List<String> list = Text.splitByTabulatorNotConsumingWhitespace(string);
        return list.size();
    }

    private void workWithLine(String string) {
        List<String> list = Text.splitByTabulatorNotConsumingWhitespace(string);
        int n = list.size();
        this.warnIfNumberOfColumnsDiffer(n);
        this.checkAllWantedColumnsAreInLine(n);
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object = this.columnNumbersToKeep.iterator();
        while (object.hasNext()) {
            int n2 = object.next();
            String string2 = list.get(n2 - 1);
            arrayList.add(string2);
        }
        object = Text.joinWithTabulator(arrayList);
        this.writer.writeln((String)object);
    }

    private void warnIfNumberOfColumnsDiffer(int n) {
        if (n != this.numberOfColumnsInFirstLine) {
            Text.say("Die Zeile " + this.lineNumber + " hat eine andere Spaltenzahl (" + n + ") als die erste Zeile (" + this.numberOfColumnsInFirstLine + ").");
        }
    }

    private void checkAllWantedColumnsAreInLine(int n) {
        if (n < this.highestColumnNumberToKeep) {
            throw new RuntimeException("Eine Zeile hat nicht gen\u00fcgend viele Spalten.\n\tEingabedatei                       : " + this.inputFilename + "\n\tZeilennummer                       : " + this.lineNumber + "\n\tAnzahl Spalten                     : " + n + "\n\tH\u00f6chste zu behaltende Spaltennummer: " + this.highestColumnNumberToKeep + "\n");
        }
    }
}

