/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.buttons.creator;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.buttons.creator.ButtonCreator;
import de.duehl.swing.ui.colors.ColorTool;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

public class ColoredLabelButtonCreator
implements ButtonCreator {
    private final Color labelColor;
    private boolean mouseEnteredLabelColorSpecified;
    private Color mouseEnteredLabelColor;
    private boolean mousePressedLabelColorSpecified;
    private Color mousePressedLabelColor;

    public ColoredLabelButtonCreator(Color color) {
        this.labelColor = color;
        this.mouseEnteredLabelColorSpecified = false;
        this.mousePressedLabelColorSpecified = false;
    }

    public ColoredLabelButtonCreator setMousePressedLabelColor(Color color) {
        this.mousePressedLabelColorSpecified = true;
        this.mousePressedLabelColor = color;
        return this;
    }

    public ColoredLabelButtonCreator setMouseEnteredLabelColor(Color color) {
        this.mouseEnteredLabelColorSpecified = true;
        this.mouseEnteredLabelColor = color;
        return this;
    }

    @Override
    public Component createButton(String string, Runnable runnable) {
        JLabel jLabel = new JLabel();
        jLabel.setText(string);
        GuiTools.boldFont(jLabel);
        GuiTools.biggerFont(jLabel, 5);
        jLabel.setHorizontalAlignment(0);
        jLabel.setVerticalAlignment(0);
        jLabel.setForeground(this.labelColor);
        this.makeLabelClickable(jLabel, runnable);
        this.addEmptyBorderArroundLabel(jLabel);
        return jLabel;
    }

    private void makeLabelClickable(final JLabel jLabel, final Runnable runnable) {
        jLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                runnable.run();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                jLabel.setForeground(ColoredLabelButtonCreator.this.createMouseEnteredLabelColor());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                jLabel.setForeground(ColoredLabelButtonCreator.this.labelColor);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                jLabel.setForeground(ColoredLabelButtonCreator.this.createMousePressedLabelColor());
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                jLabel.setForeground(ColoredLabelButtonCreator.this.createMouseEnteredLabelColor());
            }
        });
    }

    private Color createMouseEnteredLabelColor() {
        if (this.mouseEnteredLabelColorSpecified) {
            return this.mouseEnteredLabelColor;
        }
        Color color = ColorTool.anticolor(this.labelColor);
        color = ColorTool.changeColor(color, -50);
        return color;
    }

    private Color createMousePressedLabelColor() {
        if (this.mousePressedLabelColorSpecified) {
            return this.mousePressedLabelColor;
        }
        return Color.WHITE;
    }

    private void addEmptyBorderArroundLabel(JLabel jLabel) {
        jLabel.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
    }
}

