/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.dialogs;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.swing.ui.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JPanel;

public abstract class VerticalButtonSelectionDialog
extends ModalDialogBase {
    private static final Component NOT_USED_LOWER_PART = new JPanel();
    private final List<String> buttonTexts;
    private final Map<String, JButton> buttonsByTitle;
    private Component additionalFooterPart;

    public VerticalButtonSelectionDialog(List<String> list) {
        super("Bitte w\u00e4hlen");
        this.buttonTexts = list;
        this.buttonsByTitle = new HashMap<String, JButton>();
        this.fillDialog();
    }

    @Override
    protected final void populateDialog() {
        this.add(this.createMainPanel(), "Center");
    }

    private Component createMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createVerticalButtonsPart(), "Center");
        this.initAdditionalFooterPart();
        if (!this.additionalFooterPart.equals(NOT_USED_LOWER_PART)) {
            jPanel.add(this.additionalFooterPart, "South");
        }
        return jPanel;
    }

    protected void initAdditionalFooterPart() {
        this.setAdditionalFooterPart(NOT_USED_LOWER_PART);
    }

    protected final void setAdditionalFooterPart(Component component) {
        this.additionalFooterPart = component;
    }

    private Component createVerticalButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(2, 3));
        for (String string : this.buttonTexts) {
            jPanel.add(this.createButton(string));
        }
        return jPanel;
    }

    private JButton createButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(actionEvent -> this.reactOnButtonClick(actionEvent));
        jButton.setMargin(new Insets(5, 25, 5, 25));
        GuiTools.biggerFont(jButton, 3);
        if (this.buttonsByTitle.containsKey(string)) {
            throw new RuntimeException("Der Button-Text '" + string + "' wurde mehrfach vergeben!");
        }
        this.buttonsByTitle.put(string, jButton);
        return jButton;
    }

    private void reactOnButtonClick(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        this.reactOnButtonText(string);
    }

    private void reactOnButtonText(String string) {
        this.reactOnButtonClick(string);
        this.closeDialog();
    }

    protected abstract void reactOnButtonClick(String var1);

    protected void hideButton(String string) {
        JButton jButton = this.getButtonByText(string);
        jButton.setEnabled(false);
    }

    private JButton getButtonByText(String string) {
        JButton jButton = this.buttonsByTitle.get(string);
        if (null == jButton) {
            throw new RuntimeException("Der Button-Text '" + string + "' ist unbekannt!");
        }
        return jButton;
    }

    protected boolean isButtonHidden(String string) {
        return !this.isButtonActive(string);
    }

    protected boolean isButtonActive(String string) {
        JButton jButton = this.getButtonByText(string);
        return jButton.isEnabled();
    }
}

