/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.dialogs.lists;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.swing.ui.dialogs.lists.logic.LogicalEditableList;
import de.duehl.swing.ui.dialogs.lists.logic.LogicalEditableListElement;
import de.duehl.swing.ui.dialogs.lists.ui.EditableListElement;
import de.duehl.swing.ui.dialogs.lists.ui.UiElementListModifier;
import de.duehl.swing.ui.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Point;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

abstract class EditableListDialogBase<Element extends LogicalEditableListElement>
extends ModalDialogBase
implements UiElementListModifier<Element> {
    protected final LogicalEditableList<Element> logicalList;
    private final JPanel elementsPanel;
    private boolean initialUpdate;
    private boolean dataChanged;

    public EditableListDialogBase(Dimension dimension, Point point, Image image, String string, LogicalEditableList<Element> logicalEditableList) {
        super(point, image, string);
        this.setMinimumSize(dimension);
        this.logicalList = logicalEditableList;
        this.elementsPanel = new JPanel();
        this.elementsPanel.setLayout(new BorderLayout());
        GuiTools.createTitle(this.elementsPanel);
        this.initialUpdate = true;
        this.dataChanged = false;
        this.updateElementsPanel();
    }

    @Override
    public final void updateElementsPanel() {
        EventQueue.invokeLater(() -> this.updateElementsPanelInEDT());
    }

    private void updateElementsPanelInEDT() {
        this.elementsPanel.removeAll();
        this.elementsPanel.add(this.createRealElementsPart(), "Center");
        this.elementsPanel.revalidate();
        this.repaint();
        if (this.initialUpdate) {
            this.initialUpdate = false;
        } else {
            this.dataChanged = true;
        }
    }

    private Component createRealElementsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        for (LogicalEditableListElement logicalEditableListElement : this.logicalList) {
            jPanel.add(this.createRealElementPart(logicalEditableListElement));
        }
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        GuiTools.setVerticalScrollBarUnitIncrement(jScrollPane, 30);
        return jScrollPane;
    }

    protected abstract Component createRealElementPart(Element var1);

    protected final JPanel getElementsPanel() {
        return this.elementsPanel;
    }

    @Override
    protected final void populateDialog() {
        this.add(this.createMainPart(), "Center");
        this.add(this.createFooterButtonsPart(), "South");
    }

    protected abstract Component createMainPart();

    private Component createFooterButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.createQuitButton(), "East");
        return jPanel;
    }

    private JButton createQuitButton() {
        JButton jButton = new JButton("Beenden");
        jButton.setFocusable(false);
        jButton.addActionListener(actionEvent -> this.closeDialog());
        return jButton;
    }

    @Override
    public final void removeElementFromList(Element Element2) {
        this.logicalList.remove(Element2);
        this.updateElementsPanel();
    }

    @Override
    public final Component getComponent() {
        return this.getDialog();
    }

    protected final LogicalEditableList<Element> getLogicalList() {
        return this.logicalList;
    }

    protected abstract EditableListElement<Element> createUiElement(Element var1);

    public final boolean isDataChanged() {
        return this.dataChanged;
    }
}

