/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.text;

import de.duehl.swing.ui.colors.Colorizer;
import de.duehl.swing.ui.text.EditorOkReactor;
import de.duehl.swing.ui.text.TextViewer;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import javax.swing.JButton;

public class TextEditor
extends TextViewer {
    private final EditorOkReactor reactor;
    private JButton quitButton;

    public TextEditor(String string, EditorOkReactor editorOkReactor) {
        this(string, new Point(0, 0), null, editorOkReactor);
    }

    public TextEditor(String string, Point point, EditorOkReactor editorOkReactor) {
        this(string, point, null, editorOkReactor);
    }

    public TextEditor(String string, Point point, Image image, EditorOkReactor editorOkReactor) {
        this(string, point, null, image, editorOkReactor);
    }

    public TextEditor(String string, Point point, Colorizer colorizer, Image image, EditorOkReactor editorOkReactor) {
        super(string, point, colorizer, image);
        this.reactor = editorOkReactor;
    }

    @Override
    protected void initTextComponent() {
        super.initTextComponent();
        this.switchToEditable();
    }

    @Override
    protected void okPressed() {
        this.reactor.workOnText(this.getText());
        super.okPressed();
    }

    @Override
    protected Component createLeftButtonPart() {
        this.quitButton = new JButton("Abbruch");
        this.initQuitButton();
        return this.quitButton;
    }

    private void initQuitButton() {
        this.setColors(this.quitButton);
        this.quitButton.addActionListener(actionEvent -> this.closeDialog());
    }

    public final void setQuitButtonText(String string) {
        this.quitButton.setText(string);
    }

    protected final Component getQuitButton() {
        return this.quitButton;
    }

    protected final EditorOkReactor getReactor() {
        return this.reactor;
    }
}

