/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.data;

import de.duehl.basics.datetime.date.ImmutualDate;
import de.duehl.vocabulary.japanese.data.Vocable;
import java.util.List;

public class Vocabulary {
    private String description;
    private final List<Vocable> vocables;
    private String category;
    private String subCategory;
    private ImmutualDate firstSeenDate;

    public Vocabulary(String string, List<Vocable> list, String string2, String string3) {
        this.description = string;
        this.vocables = list;
        this.category = string2;
        this.subCategory = string3;
        this.firstSeenDate = new ImmutualDate();
    }

    public String getDescription() {
        return this.description;
    }

    void setDescription(String string) {
        this.description = string;
    }

    public List<Vocable> getVocables() {
        return this.vocables;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String string) {
        this.category = string;
    }

    public String getSubCategory() {
        return this.subCategory;
    }

    public void setSubCategory(String string) {
        this.subCategory = string;
    }

    public ImmutualDate getFirstSeenDate() {
        return this.firstSeenDate;
    }

    public void setFirstSeenDate(ImmutualDate immutualDate) {
        this.firstSeenDate = immutualDate;
    }

    public String toString() {
        return "Vocabulary [description=" + this.description + ", vocables=" + this.vocables + ", category=" + this.category + ", subCategory=" + this.subCategory + ", firstSeenDate=" + this.firstSeenDate + "]";
    }

    public String toNiceString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Vocabulary:\n");
        stringBuilder.append("    Beschreibung                     : " + this.description + "\n");
        stringBuilder.append("    Kategorie                        : " + this.category + "\n");
        stringBuilder.append("    Unterkategorie                   : " + this.subCategory + "\n");
        stringBuilder.append("    \u00c4ltestes Datum einer der Vokabeln: " + this.firstSeenDate + "\n");
        stringBuilder.append("    Vocables:\n");
        for (Vocable vocable : this.vocables) {
            stringBuilder.append(vocable.toNiceString(8));
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }
}

