/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.grammar.subdialogs;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.swing.ui.move.data.MovingGui;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.ui.dialog.grammar.subdialogs.bar.MovableGrammarBaseFormBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;

public class GrammarTableBaseFormUserSortDialog
extends ModalDialogBase
implements MovingGui<MovableGrammarBaseFormBar> {
    private static final Dimension DIALOG_DIMENSION = new Dimension(800, 600);
    private final List<Vocable> baseFormVocables;
    private final JPanel vocablesPanel;
    private boolean applied;

    public GrammarTableBaseFormUserSortDialog(List<Vocable> list, FumikoUiObjects fumikoUiObjects) {
        super(fumikoUiObjects.getGuiLocation(), fumikoUiObjects.getProgramImage(), "Manuelle Sotierung der Grundformen f\u00fcr die Tabelle", DIALOG_DIMENSION);
        this.baseFormVocables = list;
        this.vocablesPanel = new JPanel();
        this.applied = false;
        this.init();
        this.populateVocablesPanel();
        this.fillDialog();
    }

    private void init() {
        this.initVocablesPanel();
    }

    private void initVocablesPanel() {
        this.vocablesPanel.setLayout(new VerticalLayout(3, 3));
    }

    private void populateVocablesPanel() {
        this.vocablesPanel.removeAll();
        ArrayList<MovableGrammarBaseFormBar> arrayList = new ArrayList<MovableGrammarBaseFormBar>();
        for (int i = 0; i < this.baseFormVocables.size(); ++i) {
            MovableGrammarBaseFormBar movableGrammarBaseFormBar = new MovableGrammarBaseFormBar(this, this.baseFormVocables.get(i), i);
            arrayList.add(movableGrammarBaseFormBar);
            this.vocablesPanel.add(movableGrammarBaseFormBar.getPanel());
        }
        for (MovableGrammarBaseFormBar movableGrammarBaseFormBar : arrayList) {
            movableGrammarBaseFormBar.setUpAndDownButtonColorsAndEnabled();
        }
        this.repaint();
        this.validate();
        this.invalidate();
    }

    @Override
    public boolean canBarMoveUp(MovableGrammarBaseFormBar movableGrammarBaseFormBar) {
        int n = movableGrammarBaseFormBar.getIndex();
        return n > 0;
    }

    @Override
    public boolean canBarMoveDown(MovableGrammarBaseFormBar movableGrammarBaseFormBar) {
        int n = movableGrammarBaseFormBar.getIndex();
        return n < this.baseFormVocables.size() - 1;
    }

    @Override
    public void moveBarToFirst(MovableGrammarBaseFormBar movableGrammarBaseFormBar) {
        int n = movableGrammarBaseFormBar.getIndex();
        Vocable vocable = this.baseFormVocables.remove(n);
        this.baseFormVocables.add(0, vocable);
        this.populateVocablesPanel();
    }

    @Override
    public void moveBarUp(MovableGrammarBaseFormBar movableGrammarBaseFormBar) {
        int n = movableGrammarBaseFormBar.getIndex();
        Vocable vocable = this.baseFormVocables.remove(n);
        this.baseFormVocables.add(n - 1, vocable);
        this.populateVocablesPanel();
    }

    @Override
    public void moveBarDown(MovableGrammarBaseFormBar movableGrammarBaseFormBar) {
        int n = movableGrammarBaseFormBar.getIndex();
        Vocable vocable = this.baseFormVocables.remove(n);
        this.baseFormVocables.add(n + 1, vocable);
        this.populateVocablesPanel();
    }

    @Override
    public void moveBarToLast(MovableGrammarBaseFormBar movableGrammarBaseFormBar) {
        int n = movableGrammarBaseFormBar.getIndex();
        Vocable vocable = this.baseFormVocables.remove(n);
        this.baseFormVocables.add(vocable);
        this.populateVocablesPanel();
    }

    @Override
    protected void populateDialog() {
        this.add(GuiTools.createScrollPane(this.vocablesPanel), "Center");
        this.add(this.createButtonPart(), "South");
        this.pack();
    }

    private Component createButtonPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createQuitButton(), "West");
        jPanel.add(this.createOkButton(), "East");
        return jPanel;
    }

    private Component createQuitButton() {
        JButton jButton = new JButton("Abbrechen");
        jButton.addActionListener(actionEvent -> this.closeDialog());
        return jButton;
    }

    private Component createOkButton() {
        JButton jButton = new JButton("Auswahl best\u00e4tigen");
        jButton.addActionListener(actionEvent -> this.apply());
        return jButton;
    }

    private void apply() {
        this.applied = true;
        this.closeDialog();
    }

    public boolean isApplied() {
        return this.applied;
    }
}

