/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.testing;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.components.MultipleElementsPanel;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.swing.ui.key.BindKeysOnRootPane;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.vocabulary.japanese.common.color.VocableColors;
import de.duehl.vocabulary.japanese.common.data.TranslationDirection;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.tools.VocabularyTools;
import de.duehl.vocabulary.japanese.ui.components.display.KanjiAndKanaDisplay;
import de.duehl.vocabulary.japanese.ui.components.display.RomajiAndPronunciationDisplay;
import de.duehl.vocabulary.japanese.ui.components.display.TranslationCommentAndVocabularyDescriptionDisplay;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.ui.dialog.testing.data.VocableAndVocablePanel;
import de.duehl.vocabulary.japanese.ui.dialog.vocables.detail.VocableWithInternaDialog;
import de.duehl.vocabulary.japanese.ui.dialog.vocables.detail.addtolist.VocableToOwnListAdderGui;
import de.duehl.vocabulary.japanese.ui.dialog.vocables.detail.findlists.ListsWithVocableFinderGui;
import de.duehl.vocabulary.japanese.ui.dialog.vocables.detail.related.VerbsAndAdjectivesFinderGui;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class TranslationEvaluationDialog
extends ModalDialogBase {
    private final List<Vocable> matchingVocables;
    private final boolean correct;
    private final TranslationDirection translationDirection;
    private final FumikoDataStructures dataStructures;
    private final FumikoUiObjects uiObjects;
    private final String message;
    private final Color backgroundColor;
    private final JPanel matchingVocablesPanel;
    private final JButton quitButton;
    private List<VocableAndVocablePanel> vocablesAndVocablePanels;
    private boolean onlyTypingError;

    public TranslationEvaluationDialog(List<Vocable> list, boolean bl, TranslationDirection translationDirection, FumikoDataStructures fumikoDataStructures, FumikoUiObjects fumikoUiObjects, Point point) {
        super(point, fumikoUiObjects.getProgramImage(), (bl ? "Richtig!" : "Leider falsch") + "  -  F9, Strg-D");
        this.addEscapeBehaviour();
        this.matchingVocables = list;
        this.correct = bl;
        this.translationDirection = translationDirection;
        this.dataStructures = fumikoDataStructures;
        this.uiObjects = fumikoUiObjects;
        this.onlyTypingError = false;
        this.message = bl ? "Richtig \u00fcbersetzt, sehr gut!" : "Das war leider nicht richtig";
        Options options = fumikoDataStructures.getOptions();
        VocableColors vocableColors = new VocableColors(options);
        this.backgroundColor = bl ? vocableColors.getSuccessColor() : vocableColors.getFailureColor();
        this.matchingVocablesPanel = new JPanel();
        this.quitButton = new JButton("Beenden");
        this.fillDialog();
    }

    @Override
    protected void populateDialog() {
        this.initElements();
        this.add(this.createCenterPart(), "Center");
        this.add(this.createButtonsPart(), "South");
        this.fillWithMatchingVocables();
        if (!this.correct) {
            this.keybindingsForOnlyTypingError();
        }
        this.keybindingsForDetailDialog();
        this.keybindingsForPlaySound();
        SwingUtilities.invokeLater(() -> this.quitButton.requestFocus());
    }

    private void initElements() {
        this.matchingVocablesPanel.setLayout(new BorderLayout());
        GuiTools.addReturnListener(this.quitButton, () -> this.quitButton.doClick());
    }

    private Component createCenterPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        jPanel.add(this.createMessagePart());
        if (this.matchingVocables.size() == 1) {
            jPanel.add(this.matchingVocablesPanel);
        } else {
            jPanel.add(GuiTools.createScrollPane(this.matchingVocablesPanel));
        }
        if (!this.correct) {
            jPanel.add(this.createOnlyTypingErrorLabel());
        }
        return GuiTools.createScrollPane(jPanel);
    }

    private Component createMessagePart() {
        JLabel jLabel = new JLabel(this.message);
        GuiTools.biggerFont(jLabel, 5);
        jLabel.setOpaque(true);
        jLabel.setBackground(this.backgroundColor);
        return jLabel;
    }

    private Component createOnlyTypingErrorLabel() {
        JLabel jLabel = new JLabel("War es nur ein Tippfehler? Dann Strg-Shift-K dr\u00fccken.");
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        return jLabel;
    }

    private Component createButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createQuitButton(), "East");
        return jPanel;
    }

    private Component createQuitButton() {
        this.quitButton.addActionListener(actionEvent -> this.closeDialog());
        this.quitButton.setBackground(this.backgroundColor);
        return this.quitButton;
    }

    private void fillWithMatchingVocables() {
        this.createVocablesAndVocablePanels();
        this.displayVocablePanels();
        this.pack();
    }

    private void createVocablesAndVocablePanels() {
        this.vocablesAndVocablePanels = new ArrayList<VocableAndVocablePanel>();
        for (Vocable vocable : this.matchingVocables) {
            Component component = this.fillMatchingVocable(vocable);
            VocableAndVocablePanel vocableAndVocablePanel = new VocableAndVocablePanel(vocable, component);
            this.vocablesAndVocablePanels.add(vocableAndVocablePanel);
        }
    }

    private Component fillMatchingVocable(Vocable vocable) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        if (this.translationDirection == TranslationDirection.GERMAN_TO_JAPANESE) {
            jPanel.add(this.createKanjiAndKanaPane(vocable));
            jPanel.add(this.createRomajiAndPronunciationPane(vocable));
        }
        jPanel.add(this.createTranslationAndCommentPane(vocable));
        return jPanel;
    }

    private JTextPane createKanjiAndKanaPane(Vocable vocable) {
        Options options = this.dataStructures.getOptions();
        JTextPane jTextPane = new JTextPane();
        KanjiAndKanaDisplay kanjiAndKanaDisplay = new KanjiAndKanaDisplay(vocable, jTextPane, this.backgroundColor, options);
        kanjiAndKanaDisplay.display();
        return jTextPane;
    }

    private JTextPane createRomajiAndPronunciationPane(Vocable vocable) {
        Options options = this.dataStructures.getOptions();
        JTextPane jTextPane = new JTextPane();
        RomajiAndPronunciationDisplay romajiAndPronunciationDisplay = new RomajiAndPronunciationDisplay(vocable, jTextPane, this.backgroundColor, options);
        romajiAndPronunciationDisplay.display();
        return jTextPane;
    }

    private Component createTranslationAndCommentPane(Vocable vocable) {
        Options options = this.dataStructures.getOptions();
        JTextPane jTextPane = new JTextPane();
        TranslationCommentAndVocabularyDescriptionDisplay translationCommentAndVocabularyDescriptionDisplay = new TranslationCommentAndVocabularyDescriptionDisplay(vocable, jTextPane, this.backgroundColor, options);
        translationCommentAndVocabularyDescriptionDisplay.hideTranslationIntro();
        if (!options.isShowAllTranslations()) {
            translationCommentAndVocabularyDescriptionDisplay.setNumberOfShownTranslations(options.getNumberOfShownTranslations());
        }
        translationCommentAndVocabularyDescriptionDisplay.display();
        return jTextPane;
    }

    private void displayVocablePanels() {
        if (this.vocablesAndVocablePanels.size() == 1) {
            this.displaySingeVocable(this.vocablesAndVocablePanels.get(0));
        } else {
            this.displayMultipleVocables();
        }
    }

    private void displaySingeVocable(VocableAndVocablePanel vocableAndVocablePanel) {
        Component component = this.createComponentWithVocableAndDetailButton(vocableAndVocablePanel);
        this.matchingVocablesPanel.add(component, "Center");
    }

    private void displayMultipleVocables() {
        int n = this.vocablesAndVocablePanels.size();
        int n2 = n > 4 ? 3 : (n > 2 ? 2 : 1);
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (VocableAndVocablePanel vocableAndVocablePanel : this.vocablesAndVocablePanels) {
            Component component = this.createComponentWithVocableAndDetailButton(vocableAndVocablePanel);
            arrayList.add(component);
        }
        MultipleElementsPanel multipleElementsPanel = new MultipleElementsPanel(arrayList, n2, 1);
        this.matchingVocablesPanel.add((Component)multipleElementsPanel, "Center");
    }

    private Component createComponentWithVocableAndDetailButton(VocableAndVocablePanel vocableAndVocablePanel) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(vocableAndVocablePanel.getVocabelPanel(), "Center");
        jPanel.add(this.createButtonPart(vocableAndVocablePanel.getVocable()), "South");
        return jPanel;
    }

    private Component createButtonPart(Vocable vocable) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        jPanel.add(this.createDetailsButton(vocable));
        Options options = this.dataStructures.getOptions();
        if (options.isShowDetailBottomButonsInTranslationEvaluationToo()) {
            ListsWithVocableFinderGui listsWithVocableFinderGui = new ListsWithVocableFinderGui(vocable, this.dataStructures, this.getWindowAsComponent());
            VocableToOwnListAdderGui vocableToOwnListAdderGui = new VocableToOwnListAdderGui(vocable, this.dataStructures, this.uiObjects, this.getLocation());
            VerbsAndAdjectivesFinderGui verbsAndAdjectivesFinderGui = new VerbsAndAdjectivesFinderGui(vocable, this.dataStructures, this.uiObjects, this.getLocation(), this);
            listsWithVocableFinderGui.appendButtonToPanel(jPanel);
            vocableToOwnListAdderGui.appendButtonToPanel(jPanel);
            verbsAndAdjectivesFinderGui.appendButtonsToPanel(jPanel);
        }
        return jPanel;
    }

    private Component createDetailsButton(Vocable vocable) {
        JButton jButton = new JButton("Details anzeigen");
        jButton.addActionListener(actionEvent -> this.showDetails(vocable));
        return jButton;
    }

    private void showDetails(Vocable vocable) {
        VocableWithInternaDialog vocableWithInternaDialog = new VocableWithInternaDialog(vocable, this.dataStructures, this.uiObjects, this.getLocation());
        vocableWithInternaDialog.setVisible(true);
    }

    private void keybindingsForOnlyTypingError() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(75, 192);
        String string = "Strg-Shift-K";
        AbstractAction abstractAction = BindKeysOnRootPane.runnableToAction(() -> this.setToOnlyTypingError());
        JRootPane jRootPane = this.getRootPane();
        InputMap inputMap = jRootPane.getInputMap(2);
        inputMap.put(keyStroke, string);
        jRootPane.getActionMap().put(string, abstractAction);
    }

    private void keybindingsForDetailDialog() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(68, 128);
        String string = "Strg-D";
        AbstractAction abstractAction = BindKeysOnRootPane.runnableToAction(() -> this.showDetails());
        JRootPane jRootPane = this.getRootPane();
        InputMap inputMap = jRootPane.getInputMap(2);
        inputMap.put(keyStroke, string);
        jRootPane.getActionMap().put(string, abstractAction);
    }

    private void showDetails() {
        if (this.matchingVocables.size() == 1) {
            Vocable vocable = this.matchingVocables.get(0);
            this.showDetails(vocable);
        }
    }

    private void keybindingsForPlaySound() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(120, 0);
        String string = "F9";
        AbstractAction abstractAction = BindKeysOnRootPane.runnableToAction(() -> this.playMp3());
        JRootPane jRootPane = this.getRootPane();
        InputMap inputMap = jRootPane.getInputMap(2);
        inputMap.put(keyStroke, string);
        jRootPane.getActionMap().put(string, abstractAction);
    }

    private void playMp3() {
        if (!this.matchingVocables.isEmpty()) {
            Vocable vocable = this.matchingVocables.get(0);
            String string = vocable.getMp3();
            VocabularyTools.playMp3(string);
        }
    }

    private void setToOnlyTypingError() {
        String string = "War es nur ein Tippfehler?";
        String string2 = "War die falsche Eingabe wirklich nur ein Tippfehler?\nBitte gewissenhaft antworten und sich nicht selbst bel\u00fcgen.";
        this.onlyTypingError = GuiTools.askUser(this.getWindowAsComponent(), string, string2);
        if (this.onlyTypingError) {
            this.closeDialog();
        }
    }

    public boolean wasOnlyTypingError() {
        return this.onlyTypingError;
    }
}

