package de.duehl.basics.autodetect.tools;

/*
 * Copyright 2022 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.regex.Matcher;

/**
 * Diese Klasse führt so lange Ersetzungen durch, bis keine mehr gefunden werden.
 *
 * @version 1.01     2022-05-12
 * @author Christian Dühl
 */

public class MultiplePatternReplacer {

    /** Objekt, das für ent einen Matcher erzeugt. */
    private MatcherCreator creator;

    /** Objekt, das Code ausführt, nachdem ein Matcher für ent etwas gefunden hat. */
    private MatchingMatcherRunnable runnable;

    /**
     * Konstruktor.
     *
     * @param creator
     *            Objekt, das für ent einen Matcher erzeugt.
     * @param runnable
     *            Objekt, das Code ausführt, nachdem ein Matcher für ent etwas gefunden hat.
     */
    public MultiplePatternReplacer(MatcherCreator creator, MatchingMatcherRunnable runnable) {
        this.creator = creator;
        this.runnable = runnable;
    }

    /** Führt die wiederholte Ersetzung durch. */
    public void replace() {
        boolean replacing = true;
        while (replacing) {
            replacing = false;
            Matcher matcher = creator.createMatcher();
            if (matcher.find()) {
                replacing = true;
                runnable.runWithMatchingMatcher(matcher);
            }
        }
    }

    /**
     * Führt die wiederholte Ersetzung durch.
     *
     * @param creator
     *            Objekt, das für ent einen Matcher erzeugt.
     * @param runnable
     *            Objekt, das Code ausführt, nachdem ein Matcher für ent etwas gefunden hat.
     */
    public static void multipleReplace(MatcherCreator creator, MatchingMatcherRunnable runnable) {
        MultiplePatternReplacer replacer = new MultiplePatternReplacer(creator, runnable);
        replacer.replace();
    }

}
