package de.duehl.basics.collections;

/*
 * Copyright 2020 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Eine Klasse für eine Warteschlange von Dingen, die nur eine begrenzte Anzahl von Plätzen hat.
 *
 * Was sich zuerst anstellt, wird auch zuerst verarbeitet. Wer zu lange ansteht, wird entfernt!
 *
 * Implementiert wird hier so, dass der Kopf der Warteschlange, also das Objekt das als nächstes
 * verarbeitet wird,  bei Index 0 liegt.
 *
 * @version 1.01     2020-01-09
 * @author Christian Dühl
 */

public class LimitedQueue<E> extends Queue<E> {

    /** Anzahl der Plätze in der Warteschlange. */
    private final int numberOfPlaces;

    /** Konstruktor, erzeugt eine leere Warteschlange. */
    public LimitedQueue(int numberOfPlaces) {
        this.numberOfPlaces = numberOfPlaces;
    }

    /**
     * Stellt etwas hinten an die Warteschlange an. Falls damit die Größe der begrenzten
     * Warteschlange überschritten wird, werden die ältesten, vorn wartenden Elemente entfernt.
     *
     * @param element
     *            Anzustellendes Ding.
     */
    @Override
    public void queue(E element) {
        super.queue(element);
        while (size() > numberOfPlaces) {
            take();
        }
    }

}
