package de.duehl.basics.datetime.date.parse;

/*
 * Copyright 2018 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.regex.Pattern;

import de.duehl.basics.datetime.date.ImmutualDate;

/**
 * Diese Klasse stellt die Methode zum Parsen eines Datums mit ausgeschriebenem Monat aus einem
 * String dar.
 *
 * Erkannt werden:
 *     - 1. Feb. 2012
 *     - 1. Feb 2012
 *     - 01. Feb. 2012
 *     - 01. Feb 2012
 *     - 1. Februar. 2012
 *     - 1. Februar 2012
 *     - 01. Februar. 2012
 *     - 01. Februar 2012
 *
 * @version 1.01     2018-11-16
 * @author Christian Dühl
 */

public class DateParseMethodMonthWordsBlanks extends DateParseMethod {

    private final static Pattern PATTERN = Pattern.compile(
            "(\\d{1,2})\\.\\s*([A-ZÄÖÜa-zäöüß]+\\.?)\\s*(\\d{4})");
            // \\w greift nicht bei März !!!

    public DateParseMethodMonthWordsBlanks(String dateToParse) {
        super(dateToParse, PATTERN);
    }

    @Override
    protected ImmutualDate createDateFromMatcher() {
        int day   = Integer.parseInt(matcher.group(1));
        int month = translateMonthFromStringToInt(matcher.group(2));
        int year  = Integer.parseInt(matcher.group(3));

        return new ImmutualDate(day, month, year);
    }

}
