package de.duehl.basics.io.data;

import de.duehl.basics.io.Charset;

/**
 * Diese Klasse stellt die Parameter für die Eingabedatei dar.
 *
 * @version 1.01     2019-04-17
 * @author Christian Dühl
 */

public class InputFileParameters {

    public static final String TABULATOR = " *\t *";
    public static final String PIPE = " *\\| *";

    /** Dateiname der Eingabedatei. */
    private String filename;

    /** Trenner der Daten der Eingangsdatei in Form eines regulären Ausdrucks für split(). */
    private String delimiter;

    /** Kodierung der Eingabedatei. */
    private Charset charset;

    /** Konstruktor. */
    public InputFileParameters() {
        filename = "";
        delimiter = TABULATOR;
        charset = Charset.UTF_8;
    }

    /** Getter für den Dateinamen der Eingabedatei. */
    public String getFilename() {
        return filename;
    }

    /** Setter für den Dateinamen der Eingabedatei. */
    public void setFilename(String filename) {
        this.filename = filename;
    }

    /**
     * Getter für den Trenner der Daten der Eingangsdatei in Form eines regulären Ausdrucks für
     * split().
     */
    public String getDelimiter() {
        return delimiter;
    }

    /**
     * Legt fest, dass an Tabulatoren getrennt wird, wobei Leerzeichen davor und dahinter mit
     * entfernt werden.
     */
    public void splitByTabulators() {
        delimiter = TABULATOR;
    }

    /**
     * Legt fest, dass an Pipezeichen getrennt wird, wobei Leerzeichen davor und dahinter mit
     * entfernt werden.
     */
    public void splitByPipes() {
        delimiter = PIPE;
    }

    /**
     * Setter für den Trenner der Daten der Eingangsdatei in Form eines regulären Ausdrucks für
     * split().
     */
    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    /** Getter für die Kodierung der Eingabedatei. */
    public Charset getCharset() {
        return charset;
    }

    /** Setzt die Kodierung der Eingabedatei auf Ansi/Latin-1/ISO 8859-1. */
    public void setCharsetToAnsi() {
        charset = Charset.ISO_8859_1;
    }

    /** Setzt die Kodierung der Eingabedatei auf Utf-8 (dies ist der Default). */
    public void setCharsetToUtf8() {
        charset = Charset.UTF_8;
    }

    /** Setter für die Kodierung der Eingabedatei. */
    public void setCharset(Charset charset) {
        this.charset = charset;
    }

}
