package de.duehl.basics.logging;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Dieses Interface dient als Schnittstelle für alle Logger.
 *
 * @version 1.01     2018-07-09
 * @author Christian Dühl
 */

public interface Logger {

    /**
     * Schreibt den gegebenen Text ergänzt um einen Zeilenumbruch in das Logfile.
     * Der Offset im Stacktrace zum Ermitteln des richtigen Aufrufers ist hier 0.
     *
     * @param text
     *            Zu loggender Text.
     */
    void log(String text);

    /**
     * Schreibt den gegebenen Text ergänzt um einen Zeilenumbruch in das Logfile.
     *
     * @param text
     *            Einzutragender Text.
     * @param stacktraceOffset
     *            Offset im Stacktrace zum Ermitteln des richtigen Aufrufers.
     */
    void log(String text, int stacktraceOffset);

    /** Getter für den Dateinamen. */
    String getLogFileName();

    /** Gibt den Pfad zurück, in dem die Logdatei liegt. */
    String getLogPath();

    /**
     * Gibt die zuletzt geschriebene Zeilennummer (oder anders gesagt die Anzahl an Zeilen im
     * Logger) zurück.
     *
     * @return Zeilennummer der zuletzt geschriebenen Zeile.
     */
    int getLastWrittenLineNumber();

}
