package de.duehl.basics.logging.eraser;

/*
 * Copyright 2018 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.basics.logging.Logger;

/**
 * Dieses Klasse dient zum Loggen von Prozessabläufen nach System.out.
 *
 * @version 1.01     2018-06-14
 * @author Christian Dühl
 */

class StdOutLogger implements Logger {

    /** Konstruktor. */
    public StdOutLogger() {
        super();
    }

    /**
     * Schreibt den gegebenen Text ergänzt um einen Zeilenumbruch in das Logfile.
     *
     * @param text
     *            Zu loggender Text.
     */
    @Override
    public void log(String text) {
        logInternal(text);
    }

    @Override
    public void log(String text, int stacktraceOffset) {
        logInternal(text);
    }

    /**
     * Schreibt den gegebenen Text in das Logfile.
     *
     * @param text
     *            Zu loggender Text.
     * @param withNewLine
     *            Falls true übergeben wird, wird ein Zeilenumbruch ergänzt.
     */
    synchronized
    protected void logInternal(String text) {
        System.out.println(text);
    }

    /** Getter für den Dateinamen. */
    @Override
    public String getLogFileName() {
        throw new RuntimeException("not supported by StdOutLogger!");
    }

    /** Gibt den Pfad zurück, in dem die Logdatei liegt. */
    @Override
    public String getLogPath() {
        throw new RuntimeException("not supported by StdOutLogger!");
    }

    /**
     * Gibt die zuletzt geschriebene Zeilennummer (oder anders gesagt die Anzahl an Zeilen im
     * Logger) zurück.
     *
     * @return Zeilennummer der zuletzt geschriebenen Zeile.
     */
    @Override
    public int getLastWrittenLineNumber() {
        throw new RuntimeException("not supported by StdOutLogger!");
    }

}
