package de.duehl.basics.collections;

/*
 * Copyright 2019 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import java.util.List;
import org.junit.Test;

public class OrderedSetTest {

    @Test (expected = IllegalArgumentException.class)
    public void addTwoSameElements() {
        OrderedSet<String> set = new OrderedSet<>();
        set.add("foo");
        set.add("foo");
    }

    @Test
    public void iterateAboutElements() {
        List<String> values = CollectionsHelper.buildListFrom("foo", "bar", "baz");
        OrderedSet<String> set = new OrderedSet<>();
        for (String value : values) {
            set.add(value);
        }

        int index = 0;
        for (String element : set) {
            String value = values.get(index);
            assertEquals(value, element);
            ++index;
        }
    }

    @Test
    public void removeElement() {
        List<String> values = CollectionsHelper.buildListFrom("foo", "bar", "baz");
        OrderedSet<String> set = new OrderedSet<>();
        for (String value : values) {
            set.add(value);
        }

        set.remove("bar");
        values.remove("bar");

        int index = 0;
        for (String element : set) {
            String value = values.get(index);
            assertEquals(value, element);
            ++index;
        }
    }

    @Test (expected = IllegalArgumentException.class)
    public void removeNotContainedElement() {
        OrderedSet<String> set = new OrderedSet<>();
        set.add("foo");
        set.add("bar");

        set.remove("baz");
    }

    @Test
    public void getSize() {
        OrderedSet<String> set = new OrderedSet<>();
        set.add("foo");
        set.add("bar");
        set.add("baz");

        int actual = set.size();
        int expected = 3;
        assertEquals(expected, actual);
    }

    @Test
    public void addTwoSameElementsWhileIgnoringMultipleInsertedElements() {
        OrderedSet<String> set = new OrderedSet<>();
        set.ignoreMultipleInsertedElements();
        set.add("foo");
        set.add("foo");

        int actual = set.size();
        int expected = 1;
        assertEquals(expected, actual);
    }

    @Test
    public void contains() {
        OrderedSet<String> set = new OrderedSet<>();
        set.add("foo");
        set.add("bar");
        set.add("baz");
        
        assertTrue(set.contains("foo"));
        assertTrue(set.contains("bar"));
        assertTrue(set.contains("baz"));

        set.remove("baz");
        
        assertTrue(set.contains("foo"));
        assertTrue(set.contains("bar"));
        assertFalse(set.contains("baz"));
    }

}
