package de.duehl.basics.io.zip;

/*
 * Copyright 2020 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import org.junit.Test;

public class ZipHelperTest {

    @Test
    public void perhapsAddZipExtensionSmallZipName() {
        String zipFileName = "foo.zip";
        String actual = ZipHelper.perhapsAddZipExtension(zipFileName);
        String expected = zipFileName;
        assertEquals(expected, actual);
    }

    @Test
    public void perhapsAddZipExtensionBigZipName() {
        String zipFileName = "FOO.ZIP";
        String actual = ZipHelper.perhapsAddZipExtension(zipFileName);
        String expected = zipFileName;
        assertEquals(expected, actual);
    }

    @Test
    public void perhapsAddZipExtensionMissingZipName() {
        String zipFileName = "foo";
        String actual = ZipHelper.perhapsAddZipExtension(zipFileName);
        String expected = "foo.zip";
        assertEquals(expected, actual);
    }

}
