package de.duehl.basics.random;

/*
 * Copyright 2024 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import java.util.HashMap;
import java.util.Map;

import org.junit.Test;

public class RandomizerTest {

    @Test
    public void randomizeFrom90To110Percent() {
        Randomizer randomizer = new Randomizer();

        long number = 100;
        long min = 90;  // number - 10%
        long max = 110; // number + 10%

        Map<Long, Boolean> reached = new HashMap<>();
        for (long ranomizedNumber = min; ranomizedNumber <= max; ++ranomizedNumber) {
            reached.put(ranomizedNumber, false);
        }

        for (int i = 0; i < 10000; ++i) {
            long ranomizedNumber = randomizer.randomizeFrom90To110Percent(number);
            if (reached.containsKey(ranomizedNumber)) {
                reached.put(ranomizedNumber, true);
            }
            else {
                System.err.println("ranomizedNumber " + ranomizedNumber
                        + " nicht als Key in reached!");
                fail();
            }
        }

        for (long ranomizedNumber = min; ranomizedNumber <= max; ++ranomizedNumber) {
            boolean isReached = reached.get(ranomizedNumber);
            //System.out.println(ranomizedNumber + " => " + isReached);
            if (!isReached) {
                System.err.println("ranomizedNumber " + ranomizedNumber + " wurde nicht getroffen!");
                fail();
            }
        }
    }

}
