package de.duehl.swing.ui.buttons;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.Dimension;
import java.awt.Font;

import javax.swing.JButton;

/**
 * Diese Klasse stellt einen Button für zu startende Aufgaben dar.
 *
 * @version 1.01     2017-11-17
 * @author Christian Dühl
 */

public class JobButton extends JButton {

    private static final long serialVersionUID = 1L;

    /**
     * Konstruktor.
     *
     * @param text
     *            Auf dem Button anzuzeigender Text.
     */
    public JobButton(String text) {
        super(text);

        //setContentAreaFilled(false);
        //setEnabled(false);
        setFocusable(false);

        //setHorizontalAlignment(JButton.CENTER);

        setPreferredSize(new Dimension(200, 83));

        Font font = getFont();
        this.setFont(new Font(font.getName(), font.getStyle(), font.getSize() + 1));
    }

}
