package de.duehl.swing.ui.components.selections;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Dieses Interface steht für eine Selection, deren Fontgröße man ändern kann.
 *
 * @version 1.01     2021-08-05
 * @author Christian Dühl
 */

public interface FontSizeChangable {

    /** Vergrößert die Schriftart. */
    void biggerText(int addSize);

    /** Speichert die aktuelle Schriftgröße des Textfeldes als Standard. */
    void storeAsStandardFontSize();

    /**
     * Wechselt die Schriftgröße des Textfeldes auf den Standard, falls dieser mittels
     * storeAsStandardFontSize() zuvor gesetzt wurde.
     */
    void setToStandardFontSize();

    /** Gibt die Schriftgröße zurück. */
    int getFontSize();

    /** Setzt die Schriftgröße. */
    void setFontSize(int fontSize);

    /** Vergrößert die Schriftart der Überschrift des Textfeldes. */
    void biggerLabelText(int addSize);

    /** Speichert die aktuelle Schriftgröße der Überschrift des Textfeldes als Standard. */
    void storeAsStandardLabelFontSize();

    /**
     * Wechselt die Schriftgröße der Überschrift des Textfeldes auf den Standard, falls dieser
     * mittels storeAsStandardLabelFontSize() zuvor gesetzt wurde.
     */
    void setToStandardLabelFontSize();

    /** Gibt die Schriftgröße der Überschrift zurück. */
    int getLabelFontSize();

    /** Setzt die Schriftgröße der Überschrift. */
    void setLabelFontSize(int fontSize);

}
