package de.duehl.swing.ui.dialogs;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;

import javax.swing.JButton;
import javax.swing.JPanel;

import de.duehl.swing.ui.colors.Colorizer;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;

/**
 * Diese Klasse öffnet einen Dialog zur Anzeige des übergebenen Panels.
 *
 * @version 1.02     2017-04-13
 * @author Christian Dühl
 */

public class PanelDialog extends ModalDialogBase {

    private static final Dimension DIALOG_DIMENSION = new Dimension(600, 400);

    /** Der Panel, der hier angezeigt wird. */
    private Component panel;

    /**
     * Konstruktor.
     *
     * @param panel
     *            Anzuzeigender Panel.
     * @param parentLocation
     *            Position des Rahmens der Oberfläche, vor der dieser Dialog
     *            erzeugt wird.
     * @param programImage
     *            Image für den Dialog.
     * @param title
     *            Titel des Dialogs.
     */
    public PanelDialog(Component panel, Point parentLocation,
            Image programImage, String title) {
        this(panel, null, parentLocation, programImage, title);
    }

    /**
     * Konstruktor.
     *
     * @param panel
     *            Anzuzeigender Panel.
     * @param parentLocation
     *            Position des Rahmens der Oberfläche, vor der dieser Dialog
     *            erzeugt wird.
     * @param programImage
     *            Image für den Dialog.
     * @param title
     *            Titel des Dialogs.
     */
    public PanelDialog(Component panel, Point parentLocation,
            Image programImage, String title, Dimension dialogDimension) {
        this(panel, null, parentLocation, programImage, title, dialogDimension);
    }

    /**
     * Konstruktor.
     *
     * @param panel
     *            Anzuzeigender Panel.
     * @param colorizer
     *            Farbverwaltung für die Gui.
     * @param parentLocation
     *            Position des Rahmens der Oberfläche, vor der dieser Dialog
     *            erzeugt wird.
     * @param programImage
     *            Image für den Dialog.
     * @param title
     *            Titel des Dialogs.
     */
    public PanelDialog(Component panel, Colorizer colorizer, Point parentLocation,
            Image programImage, String title) {
        this(panel, null, parentLocation, programImage, title, DIALOG_DIMENSION);
    }

    /**
     * Konstruktor.
     *
     * @param panel
     *            Anzuzeigender Panel.
     * @param colorizer
     *            Farbverwaltung für die Gui.
     * @param parentLocation
     *            Position des Rahmens der Oberfläche, vor der dieser Dialog
     *            erzeugt wird.
     * @param programImage
     *            Image für den Dialog.
     * @param title
     *            Titel des Dialogs.
     */
    public PanelDialog(Component panel, Colorizer colorizer, Point parentLocation,
            Image programImage, String title, Dimension dialogDimension) {
        super(parentLocation, programImage, title, dialogDimension, colorizer);
        this.panel = panel;

        fillDialog();
    }

    /** Baut die Gui auf. */
    @Override
    protected void populateDialog() {
        add(panel, BorderLayout.CENTER);

        add(createButtonPart(), BorderLayout.SOUTH);

        addEscapeBehaviour();
    }

    /** Erzeugt den unteren Bereich mit den Buttons. */
    private Component createButtonPart() {
        JPanel panel = new JPanel();
        setColors(panel);
        panel.setLayout(new BorderLayout());

        panel.add(createQuitButton(), BorderLayout.EAST);

        return panel;
    }

    private JButton createQuitButton() {
        JButton button = new JButton("Schließen");
        setColors(button);
        button.addActionListener(e -> closeDialog());

        return button;
    }

}
