package de.duehl.swing.ui.filter.method;

/*
 * Copyright 2020 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.List;

/**
 * Dieses Interface repräsentiert einen Filtermethodenklasse.
 *
 * Ein 'Filter' ist hier eine Liste mit Nummern (Index + 1) der Datensätze.
 *
 * @version 1.01     2020-11-03
 * @author Christian Dühl
 */

public interface Method<Data> {

    /** Erzeugt den Filter nach der Methode. */
    public List<Integer> buildFilter(List<Data> list);

}
