package de.duehl.swing.ui.start.tabbars;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;

import javax.swing.JFrame;
import javax.swing.SwingUtilities;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.highlightingeditor.HighlightingEditor;
import de.duehl.swing.ui.highlightingeditor.HighlightingViewer;
import de.duehl.swing.ui.tabs.Tabulator;
import de.duehl.swing.ui.tabs.bars.editors.TabBarWithEditors;
import de.duehl.swing.ui.tabs.elements.TabElementsWithEditor;

/**
 * Diese Klasse testet die TabBar-Elemente.
 *
 * @version 1.01     2017-12-07
 * @author Christian Dühl
 */

public class TabBarWithEmptyViewerWithNimbusLookAndFeelTest {

    /** Die zu testenden Reiter. */
    private TabBarWithEditors tabBar;

    /** Konstruktor. */
    public TabBarWithEmptyViewerWithNimbusLookAndFeelTest() {
        GuiTools.setNiceLayoutManager();
        GuiTools.setHighlightingViewerBackgroundForNimbusLookAndFeel(
                HighlightingViewer.INACTIVE_TEXT_PANE_BACKGROUND);
        tabBar = new TabBarWithEditors();
        SwingUtilities.invokeLater(() -> createAndShowGUI());
    }

    private void createAndShowGUI() {
        JFrame frame = new JFrame("TabBarWithEditorTabs Test");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setLayout(new GridLayout(0,  1));

        frame.add(createTabBar());

        frame.setPreferredSize(new Dimension(800, 600));
        frame.pack();
        frame.setVisible(true);
    }

    private Component createTabBar() {
        addTab("foo");
        addTab("bar");
        addTab("baz");

        tabBar.focusSelectedEditor();

        return tabBar.getComponent();
    }

    private void addTab(String title) {
        HighlightingEditor editor = new HighlightingViewer();
        editor.useMonospaceFont();
        editor.setFontSize(20);
        editor.setFilenameButDoNotDoAnythingElse(title);

        TabElementsWithEditor tabElements = tabBar.addTab(editor);
        Tabulator tabulator = tabElements.getTabulator();
        editor.addChangeStateDisplayer(tabulator);
    }

    /** Startpunkt des Programms, Parameter werden ignoriert. */
    public static void main(String[] args) {
        new TabBarWithEmptyViewerWithNimbusLookAndFeelTest();
    }

}

