package de.duehl.swing.ui.windowFocusFrame;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class JWindowFocusFrameTest implements WindowFocusObserver {

    private JWindowFocusFrame frame;
    private JEditorPane editorPane;

    public JWindowFocusFrameTest() {
        /* Anlegen des Mainframes: */
        frame = new JWindowFocusFrame();
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setLayout(new BorderLayout());
        Dimension dimension = new Dimension(600, 450);
        frame.setPreferredSize(dimension);

        /* Mittleren Teil anlegen: */
        frame.add(createCenterPanel(), BorderLayout.CENTER);

        /* Unteren Teil anlegen: */
        frame.add(createLowerPart(), BorderLayout.SOUTH);

        frame.addObserver(this);

        frame.pack();
        frame.setLocation(450, 290);
    }

    @Override
    public void updateFocusGained() {
        editorPane.setEditable(true);
        editorPane.setText("Focus gained!");
        editorPane.setEditable(false);
    }

    @Override
    public void updateFocusLost() {
        editorPane.setEditable(true);
        editorPane.setText("Focus lost!");
        editorPane.setEditable(false);
    }

    private Component createCenterPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());

        editorPane = new JEditorPane();
        editorPane.setEditable(false);
        editorPane.setFocusable(false);

        panel.add(editorPane, BorderLayout.CENTER);

        JScrollPane scroll = new JScrollPane(panel);
        return scroll;
    }

    private Component createLowerPart() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());

        JButton quitButton = new JButton("Abbrechen");
        panel.add(quitButton, BorderLayout.WEST);
        quitButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent arg0) {
                quit();
            }
        });

        JButton okButton = new JButton("OK");
        panel.add(okButton, BorderLayout.EAST);
        okButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent arg0) {
                apply();
            }
        });

        return panel;
    }

    /** Reaktion auf den OK-Button. */
    private void apply() {
        closeDialog();
    }

    /** Beendet den Optionendialog. */
    private void closeDialog() {
        frame.setVisible(false);
        frame.dispose();
    }

    /** Wird beim Beenden aufgerufen, durch [x] oder Abbruch-Button. */
    public void quit() {
        closeDialog();
    }

    /** Setzt die Sichtbarkeit des Dialogs. */
    public void setVisible(boolean onOrOff) {
        frame.setVisible(onOrOff);
    }

    public static void main(String[] args) {
        new JWindowFocusFrameTest().setVisible(true);
    }

}
