package de.duehl.twosidecommander.ui.selector;

import javax.swing.JPanel;

import de.duehl.twosidecommander.ui.selector.data.IsUsedCaller;

/**
 * Diese Klasse ist die Basisklasse steht für ein Objekt, das die Auswahl einer Liste erlaubt.
 *
 * @version 1.01     2025-06-13
 * @author Christian Dühl
 */

public abstract class ListSelector {

    /** Das Objekt das aufgerufen wird, wenn die Seite aktiviert wird. */
    private IsUsedCaller isUsedCaller;

    /** Setter für das Objekt, das aufgerufen wird, wenn die Seite aktiviert wird. */
    public void setIsUsedCaller(IsUsedCaller isUsedCaller) {
        this.isUsedCaller = isUsedCaller;
    }

    /**
     * Wird aufgerufen, wenn der Selector angeklickt wurde, damit auch die zugehörige Liste als
     * aktiv gilt.
     */
    public final void isUsed() {
        if (null != isUsedCaller) {
            isUsedCaller.isUsed();
        }
    }

    /** Getter für den Panel, auf dem der Selector dargestellt wird. */
    public abstract JPanel getPanel();

    /** Stellt den Selector aktiv dar. */
    public abstract void showActive();

    /** Stellt den Selector inaktiv dar. */
    public abstract void showInactive();

}
