package de.duehl.twosidecommander.try1.list.displayer;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JPanel;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.twosidecommander.try1.element.displayer.DemoListElementDisplayer;
import de.duehl.twosidecommander.ui.list.data.ListElementMoveReactor;
import de.duehl.twosidecommander.ui.list.element.ListElementDisplayer;

public class DemoListDisplayer1 implements ListElementMoveReactor {

    private final JPanel panel;

    private final List<DemoListElementDisplayer> listElementDisplayers;

    @SuppressWarnings("unused")
    private ListElementDisplayer activeListElementDisplayer;
    /*
     * Den nutze ich hier gar nicht, das wäre ja nur für die Anzeige des aktiven Elements...
     */

    public DemoListDisplayer1() {
        panel = new JPanel();
        listElementDisplayers = new ArrayList<>();

        init();
        createDisplayers();
        initButtonColorsAndEnabled();
        initActiveElement();
        showDisplayers();
    }

    private void init() {
        initPanel();
    }

    private void initPanel() {
        panel.setLayout(new VerticalLayout(0, VerticalLayout.BOTH));
        GuiTools.createTitle(panel);
    }

    private void createDisplayers() {
        listElementDisplayers.add(createListElementDisplayer("Displayer 1"));
        listElementDisplayers.add(createListElementDisplayer("Displayer 2"));
        listElementDisplayers.add(createListElementDisplayer("Displayer 3"));
        listElementDisplayers.add(createListElementDisplayer("Displayer 4"));
        listElementDisplayers.add(createListElementDisplayer("Displayer 5"));
        listElementDisplayers.add(createListElementDisplayer("Displayer 6"));
        listElementDisplayers.add(createListElementDisplayer("Displayer 7"));
    }

    private DemoListElementDisplayer createListElementDisplayer(String text) {
        DemoListElementDisplayer displayer = new DemoListElementDisplayer(
                (ListElementMoveReactor) this, text);
        displayer.setListElementDisplayerClickReactor(
                aListElementDisplayer -> clickedOnListElement(aListElementDisplayer));
        return displayer;
    }

    private void clickedOnListElement(ListElementDisplayer aListElementDisplayer) {
        DemoListElementDisplayer demoDiscplayer =
                DemoListElementDisplayer.castListElementDisplayer(aListElementDisplayer);
        String text = demoDiscplayer.getText();
        System.out.println("Links-Klick auf Element '" + text + "'!");
    }

    private void initButtonColorsAndEnabled() {
        for (DemoListElementDisplayer listElementDisplayer : listElementDisplayers) {
            listElementDisplayer.setUpAndDownButtonColorsAndEnabled();
        }
    }

    private void initActiveElement() {
        if (!listElementDisplayers.isEmpty()) {
            activeListElementDisplayer = listElementDisplayers.get(0);
        }
    }

    private void showDisplayers() {
        panel.removeAll();
        for (DemoListElementDisplayer listElementDisplayer : listElementDisplayers) {
            panel.add(listElementDisplayer.getPanel());
        }
        panel.repaint();
        panel.validate();
        panel.invalidate();
    }

    public void showMoveButtonsOnListElements(boolean hideOrShowMoveButtons) {
        for (DemoListElementDisplayer listElementDisplayer : listElementDisplayers) {
            listElementDisplayer.showMoveButtonsOnListElements(hideOrShowMoveButtons);
        }
    }

    public final Component getComponent() {
        return panel;
    }

    @Override
    public boolean canListElementMoveUp(ListElementDisplayer displayer) {
        int index = listElementDisplayers.indexOf(displayer);
        return index > 0;
    }

    @Override
    public boolean canListElementMoveDown(ListElementDisplayer displayer) {
        int index = listElementDisplayers.indexOf(displayer);
        return index != -1 && index < listElementDisplayers.size() - 1;
    }

    @Override
    public void moveListElementToFirst(ListElementDisplayer displayer) {
        DemoListElementDisplayer demoDisplayer =
                DemoListElementDisplayer.castListElementDisplayer(displayer);
        String text = demoDisplayer.getText();
        System.out.println("nach ganz oben : " + text);

        int index = listElementDisplayers.indexOf(demoDisplayer);
        listElementDisplayers.remove(index);
        listElementDisplayers.add(0 , demoDisplayer);
        showDisplayers();
        initButtonColorsAndEnabled();
    }

    @Override
    public void moveListElementUp(ListElementDisplayer displayer) {
        DemoListElementDisplayer demoDisplayer =
                DemoListElementDisplayer.castListElementDisplayer(displayer);
        String text = demoDisplayer.getText();
        System.out.println("nach oben : " + text);

        int index = listElementDisplayers.indexOf(demoDisplayer);
        listElementDisplayers.remove(index);
        listElementDisplayers.add(index - 1, demoDisplayer);
        showDisplayers();
        initButtonColorsAndEnabled();
    }

    @Override
    public void moveListElementDown(ListElementDisplayer displayer) {
        DemoListElementDisplayer demoDisplayer =
                DemoListElementDisplayer.castListElementDisplayer(displayer);
        String text = demoDisplayer.getText();
        System.out.println("nach unten : " + text);

        int index = listElementDisplayers.indexOf(demoDisplayer);
        listElementDisplayers.remove(index);
        listElementDisplayers.add(index + 1, demoDisplayer);
        showDisplayers();
        initButtonColorsAndEnabled();
    }

    @Override
    public void moveListElementToLast(ListElementDisplayer displayer) {
        DemoListElementDisplayer demoDisplayer =
                DemoListElementDisplayer.castListElementDisplayer(displayer);
        String text = demoDisplayer.getText();
        System.out.println("nach ganz unten : " + text);

        int index = listElementDisplayers.indexOf(demoDisplayer);
        listElementDisplayers.remove(index);
        listElementDisplayers.add(demoDisplayer);
        showDisplayers();
        initButtonColorsAndEnabled();
    }

}
