package de.duehl.vocabulary.japanese.io;

import java.util.ArrayList;
import java.util.List;

import de.duehl.basics.io.Charset;
import de.duehl.basics.io.FileHelper;
import de.duehl.vocabulary.japanese.data.KanjiSet;
import de.duehl.vocabulary.japanese.data.symbol.Kanji;

/**
 * Diese Klasse schreibt eine (Teil-) Menge von Kanji, die der Benutzer definiert hat, in eine
 * Datei.
 *
 * @version 1.01     2024-11-24
 * @author Christian Dühl
 */

public class KanjiSetWriter {

    /** Speichert die übergebene Kanji-Menge ab. */
    public static void write(KanjiSet kanjiSet) {
        String filename = kanjiSet.determineFilename();

        List<String> lines = new ArrayList<>();
        lines.add(kanjiSet.getName());
        lines.add(kanjiSet.getGroup());
        for (Kanji kanji : kanjiSet.getSet()) {
            String character = kanji.getCharacter();
            lines.add(character);
        }

        FileHelper.writeLinesToFile(lines, filename, Charset.UTF_8);
    }

}
