package de.duehl.vocabulary.japanese.ui.creation.menu;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.JMenu;
import javax.swing.JMenuItem;

import de.duehl.swing.ui.menu.MyMenuItem;
import de.duehl.swing.ui.menu.SingleMenuCreation;
import de.duehl.vocabulary.japanese.ui.VocabularyTrainerGui;

/**
 * Diese Klasse erzeugt das Extra-Menü der graphischen Oberfläche des Vokabel-Trainers.
 *
 * @version 1.01     2024-11-24
 * @author Christian Dühl
 */

public class ExtraMenuCreation implements SingleMenuCreation {

    private static final boolean SHOW_SIZE_MENUE_ITEMS = false;

    /** Verbindung zur grafischen Oberfläche. */
    private final VocabularyTrainerGui gui;

    /**
     * Konstruktor.
     *
     * @param gui
     *            Verbindung zur grafischen Oberfläche.
     */
    public ExtraMenuCreation(VocabularyTrainerGui gui) {
        this.gui = gui;
    }

    /** Erzeugt das Extra-Menü. */
    @Override
    public JMenu createTheMenu() {
        JMenu menu = new JMenu("Extra");
        menu.setMnemonic('e');

        menu.add(createShowOptionsMenuItem());
        menu.add(createStatisticsMenuItem());

        if (SHOW_SIZE_MENUE_ITEMS) {
            /* TODO später ggf. mit Leben füllen und wieder aktivieren! */
            menu.addSeparator();

            menu.add(createIncreaseFontSizeMenuItem());
            menu.add(createStandardFontSizeMenuItem());
            menu.add(createDecreaseFontSizeMenuItem());

            menu.addSeparator();

            menu.add(createIncreaseLabelFontSizeMenuItem());
            menu.add(createStandardLabelFontSizeMenuItem());
            menu.add(createDecreaseLabelFontSizeMenuItem());
        }

        menu.addSeparator();

        menu.add(createToggleColorVocabularyDependingOnLastSuccessMenuItem());
        menu.add(createToggleShowSuccessPercentInVocabularyBarMenuItem());
        menu.add(createToggleHideStartOfVocabularyDescriptionMenuItem());

        menu.addSeparator();

        menu.add(createShowSplashLogMenuItem());
        menu.add(createShowSplashWarningsMenuItem());

        return menu;
    }

    private JMenuItem createShowOptionsMenuItem() {
        return new MyMenuItem("Optionen")
                .mnemonic('o')
                .accelerator(KeyEvent.VK_F5, 0)
                .actionListener(e -> gui.showOptionDialog());
    }

    private JMenuItem createStatisticsMenuItem() {
        return new MyMenuItem("Statistik anzeigen")
                .mnemonic('i')
                .accelerator(KeyEvent.VK_F8, InputEvent.CTRL_DOWN_MASK)
                .actionListener(e -> gui.showStatstics());
    }

    private JMenuItem createIncreaseFontSizeMenuItem() {
        return new MyMenuItem("größere Schrift")
                .mnemonic('g')
                .accelerator(KeyEvent.VK_PLUS, InputEvent.CTRL_DOWN_MASK)
                .actionListener(e -> gui.increaseFontSize());
    }

    private JMenuItem createStandardFontSizeMenuItem() {
        return new MyMenuItem("Zurück zur Standard-Schriftgröße")
                .mnemonic('s')
                .accelerator(KeyEvent.VK_0, InputEvent.CTRL_DOWN_MASK)
                .actionListener(e -> gui.standardFontSize());
    }

    private JMenuItem createDecreaseFontSizeMenuItem() {
        return new MyMenuItem("kleinere Schrift")
                .mnemonic('k')
                .accelerator(KeyEvent.VK_MINUS, InputEvent.CTRL_DOWN_MASK)
                .actionListener(e -> gui.decreaseFontSize());
    }

    private JMenuItem createIncreaseLabelFontSizeMenuItem() {
        return new MyMenuItem("größere Überschriften")
                .accelerator(KeyEvent.VK_PLUS, InputEvent.ALT_DOWN_MASK)
                .actionListener(e -> gui.increaseLabelFontSize());
    }

    private JMenuItem createStandardLabelFontSizeMenuItem() {
        return new MyMenuItem("Zurück zur Standard-Überschriftgröße")
                .accelerator(KeyEvent.VK_0, InputEvent.ALT_DOWN_MASK)
                .actionListener(e -> gui.standardLabelFontSize());
    }

    private JMenuItem createDecreaseLabelFontSizeMenuItem() {
        return new MyMenuItem("kleinere Überschriften")
                .accelerator(KeyEvent.VK_MINUS, InputEvent.ALT_DOWN_MASK)
                .actionListener(e -> gui.decreaseLabelFontSize());
    }

    private JMenuItem createToggleColorVocabularyDependingOnLastSuccessMenuItem() {
        return new MyMenuItem("Verändert ob die Darstellung der angezeigten Vokabularien "
                + "abhängig vom Erfolg bei den letzten zehn Abfragen eingefärbt werden "
                + "soll.")
                .accelerator(KeyEvent.VK_F1, InputEvent.CTRL_DOWN_MASK)
                .actionListener(e -> gui.toggleColorVocabularyDependingOnLastSuccess());
    }

    private JMenuItem createToggleShowSuccessPercentInVocabularyBarMenuItem() {
        return new MyMenuItem("Verändert ob der Erfolg bei den letzten zehn Abfragen der Vokabeln "
                + "eines Vokabulars als Prozentzahl mit angezeigt werden soll.")
                .accelerator(KeyEvent.VK_F2, InputEvent.CTRL_DOWN_MASK)
                .actionListener(e -> gui.toggleShowSuccessPercentInVocabularyBar());
    }

    private JMenuItem createToggleHideStartOfVocabularyDescriptionMenuItem() {
        return new MyMenuItem("Verändert ob der Anfang der Beschreibung der Vokabularien "
                + "(\"B1_K4_1_\" oder \"X_\") ausgeblendet werden soll.")
                .accelerator(KeyEvent.VK_F3, InputEvent.CTRL_DOWN_MASK)
                .actionListener(e -> gui.toggleHideStartOfVocabularyDescription());
    }

    private JMenuItem createShowSplashLogMenuItem() {
        return new MyMenuItem("Zeigt den Text an, der beim Starten des Vokabeltrainers angezeigt "
                + "wurde ...")
                //.accelerator(KeyEvent.VK_F3, InputEvent.CTRL_DOWN_MASK)
                .actionListener(e -> gui.showSplashScreenText());
    }

    private JMenuItem createShowSplashWarningsMenuItem() {
        return new MyMenuItem("Zeigt die Warnungen an, die beim Starten des Vokabeltrainers "
                + "aufgetreten sind ...")
                //.accelerator(KeyEvent.VK_F3, InputEvent.CTRL_DOWN_MASK)
                .actionListener(e -> gui.showShowSplashWarnings());
    }

}
