package de.duehl.vocabulary.japanese.website.update.ownlists.data;

/**
 * Diese Klasse stellt die Daten einer Zeile aus der Datei
 *     Eigene_Listen_Interessen_und_Versionen.txt
 * (lokal im Verzeichnis ~\.JapaneseVocableTrainer\ des Benutzers bei der Überprüfung auf
 * Neuerungen) dar.
 *
 * In dieser Datei wird festgehalten, an welchen Gruppen von eigenen Listen der Benutzer Interesse
 * hat und über welche Versionen dieser Listen er bereits informiert wurde.
 *
 * @version 1.01     2024-10-11
 * @author Christian Dühl
 */

public class OwnListInterestAndVersionEntry {

    /** Der Gruppenname ("FROM_ZERO_1"). */
    private final String groupName;

    /** Gibt an, ob der Benutzer an dieser Gruppe von eigenen Listen interessiert ist. */
    private boolean interested;

    /** Die Nummer der zuletzt gesehenen Version ("17"). */
    private final int version;

    /**
     * Konstruktor.
     *
     * @param groupName
     *            Der Gruppenname ("FROM_ZERO_1").
     * @param interested
     *            Gibt an, ob der Benutzer an dieser Gruppe von eigenen Listen interessiert ist.
     * @param version
     *            Die Nummer der zuletzt gesehenen Version ("17").
     */
    public OwnListInterestAndVersionEntry(String groupName, boolean interested, int version) {
        this.groupName = groupName;
        this.version = version;
        this.interested = interested;
    }

    /** Getter für den Gruppennamen ("FROM_ZERO_1"). */
    public String getGroupName() {
        return groupName;
    }

    /** Gibt an, ob der Benutzer an dieser Gruppe von eigenen Listen interessiert ist. */
    public boolean isInterested() {
        return interested;
    }

    /** Legt fest, ob der Benutzer an dieser Gruppe von eigenen Listen interessiert ist. */
    public void setInterested(boolean interested) {
        this.interested = interested;
    }

    /** Getter für die Nummer der zuletzt gesehenen Version ("17"). */
    public int getVersion() {
        return version;
    }

    @Override
    public String toString() {
        return "OwnListVersionAndInterest [groupName=" + groupName + ", interested=" + interested
                + ", version=" + version + "]";
    }

}
