package de.duehl.vocabulary.japanese.website.update.ownlists.interest;

import java.util.ArrayList;
import java.util.List;

import de.duehl.vocabulary.japanese.website.download.NewestOwnListVersionListDownloader;
import de.duehl.vocabulary.japanese.website.update.ownlists.data.NewestOwnListVersionListEntry;
import de.duehl.vocabulary.japanese.website.update.ownlists.data.OwnListInterestAndVersionEntry;

import static de.duehl.vocabulary.japanese.website.update.ownlists.OwnListGroupsUpdater.*;

/**
 * Diese Klasse aktualisiert das Interesse des Benutzers an den eigenen Listen und deren Versionen.
 *
 * @version 1.01     2025-10-03
 * @author Christian Dühl
 */

public class OwnListVersionsAndInterestUpdater {

    /**
     * Diese Methode aktualisiert neue, bislang nicht bekannte Listen mit einer pseudo-älteren
     * Version und Interesse des Benutzers.
     *
     * Diese Methode wird beim Startup aus der Logik aufgerufen, wenn man die Listen beim Start
     * nicht auf Aktualität prüfen möchte.
     */
    public static void updateOwnListVersionsAndInterestsForNewOwnLists() {
        List<NewestOwnListVersionListEntry> newestOwnListVersionEntries =
                NewestOwnListVersionListDownloader.download();

        if (!newestOwnListVersionEntries.isEmpty()) {
            reallyUpdateOwnListVersionsAndInterestsForNewOwnLists(newestOwnListVersionEntries);
        }
    }

    private static void reallyUpdateOwnListVersionsAndInterestsForNewOwnLists(
            List<NewestOwnListVersionListEntry> newestOwnListVersionEntries) {
        List<OwnListInterestAndVersionEntry> interestAndVersionEntries =
                OwnListVersionAndInterestIo.loadOwnListVersionAndInterests();

        List<OwnListInterestAndVersionEntry> updatedInterestAndVersionEntries = new ArrayList<>();

        for (NewestOwnListVersionListEntry newestEntry : newestOwnListVersionEntries) {
            String groupName = newestEntry.getGroupName();

            OwnListInterestAndVersionEntry interestEntry =
                    findOwnListInterestAndVersionEntryByGroupname(groupName,
                            interestAndVersionEntries);

            if (NOT_FOUND_INTEREST_AND_VERSION.equals(interestEntry)) {
                interestEntry = new OwnListInterestAndVersionEntry(groupName, true, 0);
            }
            else {
                interestEntry = new OwnListInterestAndVersionEntry(groupName,
                        interestEntry.isInterested(), newestEntry.getVersion());
            }
            updatedInterestAndVersionEntries.add(interestEntry);
        }

        OwnListVersionAndInterestIo.storeInterestAndVersionFile(updatedInterestAndVersionEntries);
    }

}
