package de.duehl.vocabulary.japanese.data;

import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.*;

public class VocableTest {

    @Test
    public void getKanjiKanaRomajiWithJapaneseBracesWithKanji() {
        Vocable vocable = new Vocable();
        vocable.setKanji("而して");
        vocable.setKana("そして");
        vocable.setRomaji("soshite");
        String actual = vocable.getKanjiKanaRomajiWithJapaneseBraces();
        String expected = "「而して」 (「そして」, soshite)";
        assertEquals(expected, actual);
    }

    @Test
    public void getKanjiKanaRomajiWithJapaneseBracesWithoutKanji() {
        Vocable vocable = new Vocable();
        vocable.setKanji("");
        vocable.setKana("でも");
        vocable.setRomaji("demo");
        String actual = vocable.getKanjiKanaRomajiWithJapaneseBraces();
        String expected = "「でも」 (demo)";
        assertEquals(expected, actual);
    }

    @Test
    public void getKanjiKanaRomajiWithJapaneseBracesWithKanjiEqualsKana() {
        // Sollte nicht mehr vorkommen, wird aber getestet.
        Vocable vocable = new Vocable();
        vocable.setKanji("でも");
        vocable.setKana("でも");
        vocable.setRomaji("demo");
        String actual = vocable.getKanjiKanaRomajiWithJapaneseBraces();
        String expected = "「でも」 (demo)";
        assertEquals(expected, actual);
    }

}
