/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.io;

import de.duehl.basics.io.Charset;
import de.duehl.basics.io.Reader;
import de.duehl.basics.io.exceptions.IORuntimeException;
import de.duehl.basics.text.Text;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class FineFileReader
implements Reader {
    private final String filename;
    private final LineNumberReader lineReader;
    private boolean closed;
    private final Charset charset;

    public FineFileReader(File file) {
        this(file.getAbsolutePath());
    }

    public FineFileReader(String string) {
        this(string, Charset.ISO_8859_1);
    }

    public FineFileReader(File file, Charset charset) {
        this(file.getAbsolutePath(), charset);
    }

    public FineFileReader(String string, Charset charset) {
        this.filename = string;
        this.charset = charset;
        this.lineReader = this.openReader();
        this.closed = false;
    }

    protected FineFileReader(String string, Charset charset, LineNumberReader lineNumberReader) {
        this.filename = string;
        this.charset = charset;
        this.lineReader = lineNumberReader;
        this.closed = false;
    }

    private LineNumberReader openReader() {
        try {
            return this.tryToOpenReader();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IORuntimeException("Die Eingabedatei '" + this.filename + "' wurde nicht gefunden. (" + fileNotFoundException.getMessage() + ")");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IORuntimeException("Bei der Erzeugung des InputStreamReaders f\u00fcr die Eingabedatei '" + this.filename + "' wurde eine nicht unterst\u00fctzte Kodierung verwendet. (" + unsupportedEncodingException.getMessage() + ")");
        }
    }

    private LineNumberReader tryToOpenReader() throws FileNotFoundException, UnsupportedEncodingException {
        FileInputStream fileInputStream = new FileInputStream(this.filename);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, this.charset.getCharsetAsString());
        return new LineNumberReader(inputStreamReader);
    }

    public String toString() {
        return "FineFileReader[fileName:" + this.filename + ", charset:" + this.charset.getCharsetAsString() + "]";
    }

    @Override
    public String readNextLine() {
        if (this.closed) {
            throw new IORuntimeException("Es wurde versucht, aus der geschlossenen Datei '" + this.filename + "' zu lesen");
        }
        try {
            return this.lineReader.readLine();
        }
        catch (IOException iOException) {
            throw new IORuntimeException("Es trat ein Fehler beim Einlesen der n\u00e4chsten Zeile aus der Datei '" + this.filename + "' auf. (" + iOException.getMessage() + ")");
        }
    }

    @Override
    public int getLineNumber() {
        return this.lineReader.getLineNumber();
    }

    @Override
    public void close() {
        if (this.closed) {
            throw new IORuntimeException("Es trat ein Fehler beim Schlie\u00dfen der Datei '" + this.filename + "' auf.");
        }
        this.tryToClose();
        this.closed = true;
    }

    private void tryToClose() {
        try {
            this.lineReader.close();
        }
        catch (IOException iOException) {
            throw new IORuntimeException("Es trat ein Fehler beim Schlie\u00dfen der Datei '" + this.filename + "' auf. (" + iOException.getMessage() + ")");
        }
    }

    @Override
    public List<String> readFileToListOfStrings() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.readNextLine();
        while (string != null) {
            arrayList.add(string);
            string = this.readNextLine();
        }
        return arrayList;
    }

    @Override
    public List<List<String>> readFileToListOfFieldLines() {
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        List<String> list = this.readFieldsLine();
        while (list != null) {
            arrayList.add(list);
            list = this.readFieldsLine();
        }
        return arrayList;
    }

    @Override
    public String readFileToString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = System.getProperty("line.separator");
        List<String> list = this.readFileToListOfStrings();
        for (String string2 : list) {
            stringBuilder.append(string2);
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    @Override
    public List<String> readFieldsLine() {
        String string = this.readNextLine();
        if (null == string) {
            return null;
        }
        return Text.splitByTabulatorNotConsumingWhitespace(string);
    }

    @Override
    public String getFileName() {
        return this.filename;
    }
}

