/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.io.textfile.dictionary;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.text.Text;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class DictionaryEntry
implements Iterable<String> {
    private final List<String> words;

    public DictionaryEntry(String string) {
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Die Hauptwort darf nicht leer sein.");
        }
        this.words = new ArrayList<String>();
        this.words.add(string);
    }

    public DictionaryEntry(List<String> list) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Die Liste darf nicht leer sein, sie muss mindestens ein Element, n\u00e4mlich das Hauptwort enthalten!");
        }
        if (list.get(0).isEmpty()) {
            throw new IllegalArgumentException("Die Hauptwort darf nicht leer sein.");
        }
        this.words = CollectionsHelper.copyList(list);
    }

    public DictionaryEntry(DictionaryEntry dictionaryEntry) {
        this.words = CollectionsHelper.copyList(dictionaryEntry.words);
    }

    public void addAlternative(String string) {
        if (!this.words.contains(string)) {
            this.words.add(string);
        }
    }

    public void addAlternatives(List<String> list) {
        for (String string : list) {
            this.addAlternative(string);
        }
    }

    @Override
    public Iterator<String> iterator() {
        return this.words.iterator();
    }

    public String getMainWord() {
        return this.words.get(0);
    }

    public List<String> getAlternatives() {
        return CollectionsHelper.sublist(this.words, 1);
    }

    public List<String> getAsFlatList() {
        return CollectionsHelper.copyList(this.words);
    }

    public boolean contains(String string) {
        return this.words.contains(string);
    }

    public boolean textContainsMainWordOrAlternative(String string) {
        for (String string2 : this.words) {
            if (!string.contains(string2)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.words.size();
    }

    public void sortAlternatives() {
        String string = this.getMainWord();
        List<String> list = this.getAlternatives();
        this.words.clear();
        this.words.add(string);
        Collections.sort(list);
        this.words.addAll(list);
    }

    public void sortAllAlternativesByLengthDescanding() {
        String string = this.getMainWord();
        List<String> list = this.getAlternatives();
        this.words.clear();
        this.words.add(string);
        CollectionsHelper.sortStringListByLengthDescanding(list);
        this.words.addAll(list);
    }

    public String createDescription(int n) {
        String string = Text.multipleString(" ", n);
        String string2 = Text.multipleString(" ", n + 4);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append(this.getMainWord()).append("\n");
        for (String string3 : this.getAlternatives()) {
            stringBuilder.append(string2).append(string3).append("\n");
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        return Objects.hash(this.words);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DictionaryEntry dictionaryEntry = (DictionaryEntry)object;
        return Objects.equals(this.words, dictionaryEntry.words);
    }

    public String toString() {
        return "DictionaryEntry [words=" + this.words + "]";
    }
}

