/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.io.zip;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.io.exceptions.ZippingException;
import de.duehl.basics.io.zip.Zip;
import de.duehl.basics.text.Text;
import java.io.File;
import java.io.FileFilter;
import java.util.List;
import java.util.zip.ZipOutputStream;

public class ZipDirectories
extends Zip {
    public ZipDirectories() {
        this(true);
    }

    public ZipDirectories(boolean bl) {
        super(bl);
    }

    public void zipDirectory(String string, String string2) {
        ZipOutputStream zipOutputStream = this.createArchive(string);
        this.addFilesOfOneDirectoryToArchive(string2, string2, zipOutputStream);
        this.closeArchive(zipOutputStream);
    }

    public void zipMultipleDirectories(String string, String ... stringArray) {
        this.zipMultipleDirectories(string, CollectionsHelper.stringArrayToList(stringArray));
    }

    public void zipMultipleDirectories(String string, List<String> list) {
        ZipOutputStream zipOutputStream = this.createArchive(string);
        for (String string2 : list) {
            this.addFilesOfOneDirectoryToArchive(string2, string2, zipOutputStream);
        }
        this.closeArchive(zipOutputStream);
    }

    public void zipMultipleDirectoriesAndSwitchTimeChangingOffAfterFirstDirectory(String string, List<String> list) {
        ZipOutputStream zipOutputStream = this.createArchive(string);
        for (String string2 : list) {
            this.addFilesOfOneDirectoryToArchive(string2, string2, zipOutputStream);
            this.switchCreationLastAccessAndModificationTimeChangingOff();
        }
        this.closeArchive(zipOutputStream);
    }

    private void addFilesOfOneDirectoryToArchive(String string, String string2, ZipOutputStream zipOutputStream) {
        String string3 = Text.allSlashesToBackslashes(string);
        String string4 = Text.allSlashesToBackslashes(string2);
        if (!FileHelper.isDirectory(string4)) {
            throw new ZippingException("Ist kein Verzeichnis: " + string4);
        }
        File file = new File(string4);
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile();
            }
        };
        for (File file2 : file.listFiles(fileFilter)) {
            this.packFile(string3, zipOutputStream, file2);
        }
        FileFilter fileFilter2 = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        };
        for (File file3 : file.listFiles(fileFilter2)) {
            this.addFilesOfOneDirectoryToArchive(string3, file3.getPath(), zipOutputStream);
        }
    }
}

