/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.text;

import de.duehl.basics.debug.Assure;
import de.duehl.basics.text.Text;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NumberString {
    private static final Pattern NUMBER_PATTERN = Pattern.compile("\\d+");
    private static final Pattern NUMBER_PATTERN_WITH_POINT = Pattern.compile("\\d[\\d\\.]*");
    private static final Pattern NUMBER_PATTERN_WITH_COMMA = Pattern.compile("\\d[\\d,]*");
    private static final Pattern ANY_NUMBER_PATTERN = Pattern.compile("\\d[\\d\\.,]*");
    private static final Pattern MATCHING_NUMBER_PATTERN = Pattern.compile("(\\d+)");
    private static final Pattern MATCHING_NUMBER_AT_FRONT_PATTERN = Pattern.compile("^(\\d+)");

    public static String taupu(int n) {
        DecimalFormat decimalFormat = new DecimalFormat(",###");
        return decimalFormat.format(n);
    }

    public static String taupu(long l) {
        DecimalFormat decimalFormat = new DecimalFormat(",###");
        return decimalFormat.format(l);
    }

    public static String removeTaupu(String string) {
        return string.replace(".", "");
    }

    public static boolean isDigitSequence(String string) {
        Matcher matcher = NUMBER_PATTERN.matcher(string);
        return matcher.matches();
    }

    public static boolean isNegativeDigitSequence(String string) {
        if (string.startsWith("-")) {
            return NumberString.isDigitSequence(string.substring(1));
        }
        return false;
    }

    public static boolean isDigitPerhapsWithPointSequence(String string) {
        Matcher matcher = NUMBER_PATTERN_WITH_POINT.matcher(string);
        return matcher.matches();
    }

    public static boolean isDigitPerhapsWithCommaSequence(String string) {
        Matcher matcher = NUMBER_PATTERN_WITH_COMMA.matcher(string);
        return matcher.matches();
    }

    public static boolean isDigitWithCommaAndTwoNachkommastellenSequence(String string) {
        int n = string.indexOf(",");
        if (n > -1) {
            int n2 = string.indexOf(",", n + 1);
            if (n2 > -1) {
                return false;
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            return string3.length() == 2 && NumberString.isDigitSequence(string2) && NumberString.isDigitSequence(string3);
        }
        return false;
    }

    public static boolean isAnyDigitSequence(String string) {
        Matcher matcher = ANY_NUMBER_PATTERN.matcher(string);
        return matcher.matches();
    }

    public static boolean containsDigit(String string) {
        Matcher matcher = NUMBER_PATTERN.matcher(string);
        return matcher.find();
    }

    public static String removeLeadingZeroes(String string) {
        String string2 = string;
        while (string2.startsWith("0")) {
            string2 = string2.substring(1);
        }
        return string2;
    }

    public static String removeZeroEnding(String string) {
        String string2 = string;
        if (string2.contains(".")) {
            while (string2.endsWith("0")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
        }
        if (string2.endsWith(".")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    public static String cleanNumber(String string) {
        String string2 = string;
        int n = Text.countPartInString(string2, ".");
        int n2 = Text.countPartInString(string2, ",");
        if (n > 1 || n2 > 0) {
            string2 = string2.replace(".", "");
        }
        if (n2 > 1) {
            string2 = string2.replace(",", "");
        }
        string2 = string2.replace(",", ".");
        return string2;
    }

    public static List<Integer> findNumbers(String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (String string2 : NumberString.findNumberStrings(string)) {
            Integer n = Integer.parseInt(string2);
            arrayList.add(n);
        }
        return arrayList;
    }

    public static List<String> findNumberStrings(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Matcher matcher = MATCHING_NUMBER_PATTERN.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group(1);
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static int findNaturalNumberAtStart(String string) {
        String string2 = NumberString.findNaturalNumberAtStartString(string);
        if (string2.isEmpty()) {
            return -1;
        }
        return Integer.parseInt(string2);
    }

    public static String findNaturalNumberAtStartString(String string) {
        Matcher matcher = MATCHING_NUMBER_AT_FRONT_PATTERN.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    public static String addLeadingZeroes(int n, int n2) {
        String string = Integer.toString(n);
        if (string.length() >= n2 || n < 0 || n2 < 0) {
            return string;
        }
        return Text.multipleString("0", n2 - string.length()) + string;
    }

    public static String addLeadingZeroes(long l, int n) {
        String string = Long.toString(l);
        if (string.length() >= n || l < 0L || n < 0) {
            return string;
        }
        return Text.multipleString("0", n - string.length()) + string;
    }

    public static String addLeadingZeroes(String string, int n) {
        String string2 = string;
        if (string2.length() >= n || string.startsWith("-") || n < 0) {
            return string2;
        }
        return Text.multipleString("0", n - string2.length()) + string2;
    }

    public static int parseInt(String string) {
        String string2 = "L\u00e4sst sich nicht als Integer parsen: '" + string + "'";
        return NumberString.parseInt(string, string2);
    }

    public static List<Integer> parseInts(List<String> list) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (String string : list) {
            int n = NumberString.parseInt(string);
            arrayList.add(n);
        }
        return arrayList;
    }

    public static int parseInt(String string, String string2) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException(string2, numberFormatException);
        }
    }

    public static int parseIntIgnore(String string, int n) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static boolean isInteger(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static long parseLong(String string) {
        String string2 = "L\u00e4sst sich nicht als Long parsen: '" + string + "'";
        return NumberString.parseLong(string, string2);
    }

    public static long parseLong(String string, String string2) {
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException(string2, numberFormatException);
        }
    }

    public static long parseLongIgnore(String string, long l) {
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return l;
        }
    }

    public static double parseDouble(String string, String string2) {
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException(string2, numberFormatException);
        }
    }

    public static double parseDoubleIgnore(String string, double d) {
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }

    public static int twoDigitStringToInteger(String string) {
        if (string.length() != 2) {
            throw new RuntimeException("Es werden zwei Stellen erwartet! twoDigits = '" + string + "'.");
        }
        String string2 = string.startsWith("0") ? string.substring(1) : string;
        return Integer.parseInt(string2);
    }

    public static String twoDecimalPlaces(double d) {
        return String.format("%.02f", d);
    }

    public static String twoDecimalPlacesTaupu(double d) {
        long l = (long)d;
        double d2 = d - (double)l;
        String string = NumberString.twoDecimalPlaces(d2);
        String string2 = string.substring(1);
        return NumberString.taupu(l) + string2;
    }

    public static List<String> doubleListToTwoDecimalPlacesTaupuList(List<Double> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (double d : list) {
            String string = NumberString.twoDecimalPlacesTaupu(d);
            arrayList.add(string);
        }
        return arrayList;
    }

    public static int calculateDigits(int n) {
        Assure.isAtLeast(n, 0);
        return Integer.toString(n).length();
    }

    public static double percentAsNumber(int n, int n2) {
        return 100.0 * ((double)n / (double)n2);
    }

    public static String percent(int n, int n2) {
        return NumberString.twoDecimalPlaces(NumberString.percentAsNumber(n, n2));
    }

    public static double percentAsNumber(long l, long l2) {
        return 100.0 * ((double)l / (double)l2);
    }

    public static String percent(long l, long l2) {
        return NumberString.twoDecimalPlaces(NumberString.percentAsNumber(l, l2));
    }

    public static String toGermanNumber(String string) {
        if (string.equals("0")) {
            return "Null";
        }
        if (string.equals("1")) {
            return "Ein";
        }
        return string;
    }

    public static String toSmallGermanNumber(String string) {
        if (string.equals("0")) {
            return "kein";
        }
        if (string.equals("1")) {
            return "ein";
        }
        return string;
    }

    public static String toSmallGermanNumber(int n) {
        if (n == 0) {
            return "kein";
        }
        if (n == 1) {
            return "ein";
        }
        return Integer.toString(n);
    }

    public static String toSmallGermanNumberWithE(String string) {
        if (string.equals("0")) {
            return "keine";
        }
        if (string.equals("1")) {
            return "eine";
        }
        return string;
    }

    public static String toSmallGermanNumberWithE(int n) {
        if (n == 0) {
            return "keine";
        }
        if (n == 1) {
            return "eine";
        }
        return Integer.toString(n);
    }

    public static String germanPlural(int n, String string, String string2) {
        if (n == 1) {
            return string2;
        }
        return string;
    }

    public static long hexPow(int n) {
        long l = 16L;
        long l2 = 1L;
        for (int i = 0; i < n; ++i) {
            l2 *= l;
        }
        return l2;
    }

    public static long hexChar2long(String string) {
        if (string.length() != 1) {
            throw new IllegalArgumentException("Die Methode hexChar2long() darf nur mit einer einstelligen hexadezimalen Ziffer aufgerufen werden.");
        }
        switch (Text.toLowerCase(string)) {
            case "0": {
                return 0L;
            }
            case "1": {
                return 1L;
            }
            case "2": {
                return 2L;
            }
            case "3": {
                return 3L;
            }
            case "4": {
                return 4L;
            }
            case "5": {
                return 5L;
            }
            case "6": {
                return 6L;
            }
            case "7": {
                return 7L;
            }
            case "8": {
                return 8L;
            }
            case "9": {
                return 9L;
            }
            case "a": {
                return 10L;
            }
            case "b": {
                return 11L;
            }
            case "c": {
                return 12L;
            }
            case "d": {
                return 13L;
            }
            case "e": {
                return 14L;
            }
            case "f": {
                return 15L;
            }
        }
        throw new IllegalArgumentException("Die Methode hexChar2long() darf nur mit einer einstelligen hexadezimalen Ziffer mit einem der m\u00f6glichen Werte 0-9, a-f oder A-F aufgerufen werden.");
    }

    public static long hex2long(String string) {
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Die Methode hex2long() darf nicht mit eine leeren Eingabe aufgerufen werden.");
        }
        long l = 0L;
        for (int i = 0; i < string.length(); ++i) {
            String string2 = string.substring(i, i + 1);
            int n = string.length() - i - 1;
            long l2 = NumberString.hexPow(n);
            long l3 = NumberString.hexChar2long(string2);
            long l4 = l3 * l2;
            l += l4;
        }
        return l;
    }

    public static String cleanNumberFromSpacesAndLeadingZeros(String string) {
        String string2 = string;
        string2 = Text.removeWhitespace(string2);
        string2 = NumberString.removeLeadingZeroes(string2);
        return string2;
    }

    public static boolean isPipeSeparatedListOfNumbers(String string) {
        List<String> list = Text.splitByPipeNotConsumingWhitespace(string);
        if (list.isEmpty()) {
            return false;
        }
        for (String string2 : list) {
            if (NumberString.isDigitSequence(string2)) continue;
            return false;
        }
        return true;
    }

    public static boolean looksLikeNumberPerhapsWithSpaceSlashMinus(String string) {
        String string2 = Text.removeWhitespace(string);
        string2 = string2.replace("/", "");
        string2 = string2.replace("-", "");
        return NumberString.isDigitSequence(string2);
    }

    public static boolean startsWithDigit(String string) {
        if (string.isEmpty()) {
            return false;
        }
        String string2 = string.substring(0, 1);
        return Text.DIGITS.contains(string2);
    }

    public static boolean startsWithFiveDigitAndSpace(String string) {
        if (string.length() < 6) {
            return false;
        }
        String string2 = string.substring(0, 1);
        String string3 = string.substring(1, 2);
        String string4 = string.substring(2, 3);
        String string5 = string.substring(3, 4);
        String string6 = string.substring(4, 5);
        String string7 = string.substring(5, 6);
        return Text.DIGITS.contains(string2) && Text.DIGITS.contains(string3) && Text.DIGITS.contains(string4) && Text.DIGITS.contains(string5) && Text.DIGITS.contains(string6) && string7.equals(" ");
    }

    public static boolean endsWithDigit(String string) {
        if (string.isEmpty()) {
            return false;
        }
        String string2 = string.substring(string.length() - 1, string.length());
        return Text.DIGITS.contains(string2);
    }

    public static String taupuIfPossible(String string) {
        if (NumberString.isDigitSequence(string)) {
            try {
                long l = Long.parseLong(string);
                return NumberString.taupu(l);
            }
            catch (NumberFormatException numberFormatException) {
                return string;
            }
        }
        return string;
    }

    public static String numberAndPercent(int n, int n2, int n3) {
        String string = NumberString.taupu(n);
        string = Text.fillWithSpacesAtFront(string, n3);
        String string2 = NumberString.percent(n, n2);
        string2 = Text.fillWithSpacesAtFront(string2, 6);
        String string3 = "(" + string2 + "%)";
        return string + " " + string3;
    }

    public static double parseDoubleWithTaupuAndKomma(String string, double d) {
        String string2 = string.replace(".", "");
        String string3 = string2.replace(",", ".");
        return NumberString.parseDoubleIgnore(string3, d);
    }
}

