/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.area;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class TextInserter
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private JTextArea area;
    private String insertable;

    private TextInserter(JTextArea jTextArea, String string) {
        this.area = jTextArea;
        this.insertable = string;
    }

    public static void applyTabBinding(JTextArea jTextArea) {
        TextInserter.applyKeyBindung(9, jTextArea);
    }

    public static void applyEnterBinding(JTextArea jTextArea) {
        TextInserter.applyKeyBindung(10, jTextArea);
    }

    private static void applyKeyBindung(int n, JTextArea jTextArea) {
        String string;
        String string2;
        if (n != 9 && n != 10) {
            throw new IllegalArgumentException("Illegales keyEvent " + n);
        }
        InputMap inputMap = jTextArea.getInputMap(0);
        int n2 = 128;
        KeyStroke keyStroke = KeyStroke.getKeyStroke(n, n2);
        if (n == 9) {
            string2 = "tab";
            string = "\t";
        } else {
            string2 = "enter";
            string = System.getProperty("line.separator");
        }
        inputMap.put(keyStroke, string2);
        ActionMap actionMap = jTextArea.getActionMap();
        TextInserter textInserter = new TextInserter(jTextArea, string);
        actionMap.put(string2, textInserter);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = this.area.getSelectedText();
        if (null != string && !string.isEmpty()) {
            this.area.replaceSelection(this.insertable);
        } else {
            this.area.insert(this.insertable, this.area.getCaretPosition());
        }
    }
}

